/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import org.springframework.test.context.transaction.TransactionContext;
import org.springframework.test.context.transaction.TransactionContextHolder;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;

public class TestTransaction {
    public static boolean isActive() {
        TransactionContext transactionContext = TransactionContextHolder.getCurrentTransactionContext();
        if (transactionContext != null) {
            TransactionStatus transactionStatus = transactionContext.getTransactionStatus();
            return transactionStatus != null && !transactionStatus.isCompleted();
        }
        return false;
    }

    public static boolean isFlaggedForRollback() {
        return TestTransaction.requireCurrentTransactionContext().isFlaggedForRollback();
    }

    public static void flagForRollback() {
        TestTransaction.setFlaggedForRollback(true);
    }

    public static void flagForCommit() {
        TestTransaction.setFlaggedForRollback(false);
    }

    public static void start() {
        TestTransaction.requireCurrentTransactionContext().startTransaction();
    }

    public static void end() {
        TestTransaction.requireCurrentTransactionContext().endTransaction();
    }

    private static TransactionContext requireCurrentTransactionContext() {
        TransactionContext txContext = TransactionContextHolder.getCurrentTransactionContext();
        Assert.state(txContext != null, "TransactionContext is not active");
        return txContext;
    }

    private static void setFlaggedForRollback(boolean flag) {
        TestTransaction.requireCurrentTransactionContext().setFlaggedForRollback(flag);
    }
}

