/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringTemplateLoader
implements TemplateLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final String templateLoaderPath;

    public SpringTemplateLoader(ResourceLoader resourceLoader, String templateLoaderPath) {
        this.resourceLoader = resourceLoader;
        if (!templateLoaderPath.endsWith("/")) {
            templateLoaderPath = templateLoaderPath + "/";
        }
        this.templateLoaderPath = templateLoaderPath;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SpringTemplateLoader for FreeMarker: using resource loader [" + this.resourceLoader + "] and template loader path [" + this.templateLoaderPath + "]");
        }
    }

    @Override
    public Object findTemplateSource(String name) throws IOException {
        Resource resource;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for FreeMarker template with name [" + name + "]");
        }
        return (resource = this.resourceLoader.getResource(this.templateLoaderPath + name)).exists() ? resource : null;
    }

    @Override
    public Reader getReader(Object templateSource, String encoding) throws IOException {
        Resource resource = (Resource)templateSource;
        try {
            return new InputStreamReader(resource.getInputStream(), encoding);
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not find FreeMarker template: " + resource);
            }
            throw ex;
        }
    }

    @Override
    public long getLastModified(Object templateSource) {
        Resource resource = (Resource)templateSource;
        try {
            return resource.lastModified();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not obtain last-modified timestamp for FreeMarker template in " + resource + ": " + ex);
            }
            return -1L;
        }
    }

    @Override
    public void closeTemplateSource(Object templateSource) throws IOException {
    }
}

