/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

class RequestResponseBodyAdviceChain
implements RequestBodyAdvice,
ResponseBodyAdvice<Object> {
    private final List<Object> requestBodyAdvice = new ArrayList<Object>(4);
    private final List<Object> responseBodyAdvice = new ArrayList<Object>(4);

    public RequestResponseBodyAdviceChain(List<Object> requestResponseBodyAdvice) {
        this.initAdvice(requestResponseBodyAdvice);
    }

    private void initAdvice(List<Object> requestResponseBodyAdvice) {
        if (requestResponseBodyAdvice == null) {
            return;
        }
        for (Object advice : requestResponseBodyAdvice) {
            Class<?> beanType;
            Class<?> clazz = beanType = advice instanceof ControllerAdviceBean ? ((ControllerAdviceBean)advice).getBeanType() : advice.getClass();
            if (RequestBodyAdvice.class.isAssignableFrom(beanType)) {
                this.requestBodyAdvice.add(advice);
            }
            if (!ResponseBodyAdvice.class.isAssignableFrom(beanType)) continue;
            this.responseBodyAdvice.add(advice);
        }
    }

    private List<Object> getAdvice(Class<?> adviceType) {
        if (RequestBodyAdvice.class == adviceType) {
            return this.requestBodyAdvice;
        }
        if (ResponseBodyAdvice.class == adviceType) {
            return this.responseBodyAdvice;
        }
        throw new IllegalArgumentException("Unexpected adviceType: " + adviceType);
    }

    @Override
    public boolean supports(MethodParameter param, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class)) {
            if (!advice.supports(parameter, targetType, converterType)) continue;
            body = advice.handleEmptyBody(body, inputMessage, parameter, targetType, converterType);
        }
        return body;
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage request, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class)) {
            if (!advice.supports(parameter, targetType, converterType)) continue;
            request = advice.beforeBodyRead(request, parameter, targetType, converterType);
        }
        return request;
    }

    @Override
    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class)) {
            if (!advice.supports(parameter, targetType, converterType)) continue;
            body = advice.afterBodyRead(body, inputMessage, parameter, targetType, converterType);
        }
        return body;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType contentType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        return this.processBody(body, returnType, contentType, converterType, request, response);
    }

    private <T> Object processBody(Object body, MethodParameter returnType, MediaType contentType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        for (ResponseBodyAdvice advice : this.getMatchingAdvice(returnType, ResponseBodyAdvice.class)) {
            if (!advice.supports(returnType, converterType)) continue;
            body = advice.beforeBodyWrite(body, returnType, contentType, converterType, request, response);
        }
        return body;
    }

    private <A> List<A> getMatchingAdvice(MethodParameter parameter, Class<? extends A> adviceType) {
        List<Object> availableAdvice = this.getAdvice(adviceType);
        if (CollectionUtils.isEmpty(availableAdvice)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(availableAdvice.size());
        for (Object advice : availableAdvice) {
            if (advice instanceof ControllerAdviceBean) {
                ControllerAdviceBean adviceBean = (ControllerAdviceBean)advice;
                if (!adviceBean.isApplicableToBeanType(parameter.getContainingClass())) continue;
                advice = adviceBean.resolveBean();
            }
            if (!adviceType.isAssignableFrom(advice.getClass())) continue;
            result.add(advice);
        }
        return result;
    }
}

