/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDictionaryStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateDictionaryStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        CubeManager cubeMgr = CubeManager.getInstance(context.getConfig());
        CubeInstance cube = cubeMgr.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment newSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        List<CubeSegment> mergingSegments = this.getMergingSegments(cube);
        String dictInfoPath = this.getParams().get("dictPath");
        String metadataUrl = this.getParams().get("metaUrl");
        KylinConfig kylinConfHbase = cube.getConfig();
        KylinConfig kylinConfHdfs = AbstractHadoopJob.loadKylinConfigFromHdfs(metadataUrl);
        Collections.sort(mergingSegments);
        try {
            FileStatus[] fileStatuss;
            Configuration conf = HadoopUtil.getCurrentConfiguration();
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            ResourceStore hbaseRS = ResourceStore.getStore(kylinConfHbase);
            ResourceStore hdfsRS = ResourceStore.getStore(kylinConfHdfs);
            DictionaryManager dictMgrHdfs = DictionaryManager.getInstance(kylinConfHdfs);
            DictionaryManager dictMgrHbase = DictionaryManager.getInstance(kylinConfHbase);
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            CubeSegment newSegCopy = cubeCopy.getSegmentById(newSegment.getUuid());
            for (FileStatus fileStatus : fileStatuss = fs.listStatus(new Path(dictInfoPath), new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith("part") || path.getName().startsWith("tmp");
                }
            })) {
                Path filePath = fileStatus.getPath();
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, filePath, conf);
                Text key = (Text)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Text value = (Text)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                while (reader.next((Writable)key, (Writable)value)) {
                    String tblCol = key.toString();
                    String dictInfoResource = value.toString();
                    if (!StringUtils.isNotEmpty(dictInfoResource)) continue;
                    logger.info(dictInfoResource);
                    DictionaryInfo dictInfoHdfs = dictMgrHdfs.getDictionaryInfo(dictInfoResource);
                    DictionaryInfo dicInfoHbase = dictMgrHbase.trySaveNewDict(dictInfoHdfs.getDictionaryObject(), dictInfoHdfs);
                    if (dicInfoHbase == null) continue;
                    TblColRef tblColRef = cube.getDescriptor().findColumnRef(tblCol.split(":")[0], tblCol.split(":")[1]);
                    newSegCopy.putDictResPath(tblColRef, dicInfoHbase.getResourcePath());
                }
                IOUtils.closeStream((Closeable)reader);
            }
            CubeSegment lastSeg = mergingSegments.get(mergingSegments.size() - 1);
            for (Map.Entry<String, String> entry : lastSeg.getSnapshots().entrySet()) {
                newSegCopy.putSnapshotResPath(entry.getKey(), entry.getValue());
            }
            String statisticsFileName = newSegment.getStatisticsResourcePath();
            hbaseRS.putResource(statisticsFileName, hdfsRS.getResource(newSegment.getStatisticsResourcePath()).content(), System.currentTimeMillis());
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToUpdateSegs(newSegCopy);
            cubeMgr.updateCube(update);
            return ExecuteResult.createSucceed();
        }
        catch (IOException e) {
            logger.error("fail to merge dictionary", e);
            return ExecuteResult.createError(e);
        }
    }

    private List<CubeSegment> getMergingSegments(CubeInstance cube) {
        List<String> mergingSegmentIds = CubingExecutableUtil.getMergingSegmentIds(this.getParams());
        ArrayList<CubeSegment> result = Lists.newArrayListWithCapacity(mergingSegmentIds.size());
        for (String id : mergingSegmentIds) {
            result.add(cube.getSegmentById(id));
        }
        return result;
    }
}

