/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.constant;

public enum JobStatusEnum {
    NEW(0),
    PENDING(1),
    RUNNING(2),
    FINISHED(4),
    ERROR(8),
    DISCARDED(16),
    STOPPED(32);

    private final int code;

    private JobStatusEnum(int statusCode) {
        this.code = statusCode;
    }

    public static JobStatusEnum getByCode(int statusCode) {
        for (JobStatusEnum status : JobStatusEnum.values()) {
            if (status.getCode() != statusCode) continue;
            return status;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isComplete() {
        return this.code == FINISHED.getCode() || this.code == ERROR.getCode() || this.code == DISCARDED.getCode();
    }
}

