/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.hive;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.lib.impl.hive.HiveProducerRecord;
import org.apache.kylin.metrics.lib.impl.hive.HiveReservoirReporter;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.cache.CacheLoader;
import org.apache.kylin.shaded.com.google.common.cache.LoadingCache;
import org.apache.kylin.shaded.com.google.common.cache.RemovalListener;
import org.apache.kylin.shaded.com.google.common.cache.RemovalNotification;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.hive.HiveMetaStoreClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveProducer {
    private static final Logger logger = LoggerFactory.getLogger(HiveProducer.class);
    private static final int CACHE_MAX_SIZE = 10;
    private final HiveConf hiveConf;
    private FileSystem fs;
    private final LoadingCache<Pair<String, String>, Pair<String, List<FieldSchema>>> tableFieldSchemaCache;
    private final String contentFilePrefix;
    private String metricType;
    private String prePartitionPath;
    private Path curPartitionContentPath;
    private int id = 0;
    private FSDataOutputStream fout;
    private final boolean supportAppend;
    private final boolean closeFileEveryAppend;
    private final Map<String, String> kylinSpecifiedConfig = new HashMap<String, String>();

    public HiveProducer(String metricType, Properties props) throws Exception {
        this(metricType, props, new HiveConf());
    }

    HiveProducer(String metricType, Properties props, HiveConf hiveConfig) throws Exception {
        String hostName;
        this.metricType = metricType;
        this.hiveConf = hiveConfig;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            if (key.startsWith("kylin.")) {
                this.kylinSpecifiedConfig.put(key, value);
                continue;
            }
            this.hiveConf.set(key, value);
        }
        this.fs = FileSystem.get((Configuration)this.hiveConf);
        this.tableFieldSchemaCache = CacheBuilder.newBuilder().removalListener(new RemovalListener<Pair<String, String>, Pair<String, List<FieldSchema>>>(){

            @Override
            public void onRemoval(RemovalNotification<Pair<String, String>, Pair<String, List<FieldSchema>>> notification) {
                logger.info("Field schema with table " + ActiveReservoirReporter.getTableName((Pair)notification.getKey()) + " is removed due to " + (Object)((Object)notification.getCause()));
            }
        }).maximumSize(10L).build(new CacheLoader<Pair<String, String>, Pair<String, List<FieldSchema>>>(){

            @Override
            public Pair<String, List<FieldSchema>> load(Pair<String, String> tableName) throws Exception {
                IMetaStoreClient metaStoreClient = HiveMetaStoreClientFactory.getHiveMetaStoreClient(HiveProducer.this.hiveConf);
                String tableLocation = metaStoreClient.getTable(tableName.getFirst(), tableName.getSecond()).getSd().getLocation();
                logger.debug("Find table location for {} at {}", (Object)tableName.getSecond(), (Object)tableLocation);
                List fields = metaStoreClient.getFields(tableName.getFirst(), tableName.getSecond());
                metaStoreClient.close();
                return new Pair<String, List<FieldSchema>>(tableLocation, fields);
            }
        });
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "UNKNOWN";
        }
        this.contentFilePrefix = hostName + "-" + System.currentTimeMillis() + "-part-";
        String fsUri = this.fs.getUri().toString();
        this.supportAppend = fsUri.startsWith("hdfs");
        logger.info("For {}, supportAppend was set to {}", (Object)fsUri, (Object)this.supportAppend);
        this.closeFileEveryAppend = !this.supportAppend || Boolean.parseBoolean(this.kylinSpecifiedConfig.get("kylin.hive.producer.close-file-every-append"));
    }

    public void close() {
        this.tableFieldSchemaCache.cleanUp();
        this.closeFout();
    }

    public void send(Record record) throws Exception {
        HiveProducerRecord hiveRecord = this.convertTo(record);
        this.write(hiveRecord.key(), Lists.newArrayList(hiveRecord));
    }

    public void send(List<Record> recordList) throws Exception {
        HashMap recordMap = Maps.newHashMap();
        for (Record record : recordList) {
            HiveProducerRecord hiveRecord = this.convertTo(record);
            if (recordMap.get(hiveRecord.key()) == null) {
                recordMap.put(hiveRecord.key(), Lists.newLinkedList());
            }
            ((List)recordMap.get(hiveRecord.key())).add(hiveRecord);
        }
        for (Map.Entry entry : recordMap.entrySet()) {
            this.write((HiveProducerRecord.RecordKey)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HiveProducerRecord.RecordKey recordKey, Iterable<HiveProducerRecord> recordItr) throws Exception {
        String tableLocation = this.tableFieldSchemaCache.get(new Pair<String, String>(recordKey.database(), recordKey.table())).getFirst();
        StringBuilder sb = new StringBuilder();
        sb.append(tableLocation);
        for (Map.Entry<String, String> e : recordKey.partition().entrySet()) {
            sb.append("/");
            sb.append(e.getKey().toLowerCase(Locale.ROOT));
            sb.append("=");
            sb.append(e.getValue());
        }
        Path partitionPath = new Path(sb.toString());
        if (partitionPath.toUri().getScheme() != null && !partitionPath.toUri().toString().startsWith(this.fs.getUri().toString())) {
            this.fs.close();
            this.fs = partitionPath.getFileSystem((Configuration)this.hiveConf);
        }
        if (!this.fs.exists(partitionPath)) {
            StringBuilder hql = new StringBuilder();
            hql.append("ALTER TABLE ");
            hql.append(recordKey.database() + "." + recordKey.table());
            hql.append(" ADD IF NOT EXISTS PARTITION (");
            boolean ifFirst = true;
            for (Map.Entry<String, String> e : recordKey.partition().entrySet()) {
                if (ifFirst) {
                    ifFirst = false;
                } else {
                    hql.append(",");
                }
                hql.append(e.getKey().toLowerCase(Locale.ROOT));
                hql.append("='" + e.getValue() + "'");
            }
            hql.append(")");
            logger.debug("create partition by {}.", (Object)hql);
            Driver driver = null;
            CliSessionState session = null;
            try {
                driver = new Driver(this.hiveConf);
                session = new CliSessionState(this.hiveConf);
                SessionState.start((SessionState)session);
                CommandProcessorResponse res = driver.run(hql.toString());
                if (res.getResponseCode() != 0) {
                    logger.warn("Fail to add partition. HQL: {}; Cause by: {}", (Object)hql.toString(), (Object)res.toString());
                }
                session.close();
                driver.close();
            }
            catch (Exception ex) {
                logger.error("create partition failed, please create it manually : " + hql, ex);
            }
            finally {
                if (session != null) {
                    session.close();
                }
                if (driver != null) {
                    driver.close();
                }
            }
        }
        if (this.fout == null || this.prePartitionPath == null || this.prePartitionPath.compareTo(partitionPath.toString()) != 0) {
            if (this.fout != null) {
                logger.debug("Flush output stream of previous partition path {}. Using a new one {}. ", (Object)this.prePartitionPath, (Object)partitionPath);
                this.closeFout();
            }
            Path partitionContentPath = new Path(partitionPath, this.contentFilePrefix + String.format(Locale.ROOT, "%05d", this.id));
            int nCheck = 0;
            while (!this.supportAppend && this.fs.exists(partitionContentPath)) {
                ++this.id;
                partitionContentPath = new Path(partitionPath, this.contentFilePrefix + String.format(Locale.ROOT, "%05d", this.id));
                logger.debug("{} exists, skip it.", (Object)partitionContentPath);
                if (++nCheck <= 100000) continue;
                logger.warn("Exceed max check times.");
                break;
            }
            logger.info("Try to use new partition content path: {} for metric: {}", (Object)partitionContentPath, (Object)this.metricType);
            if (!this.fs.exists(partitionContentPath)) {
                int nRetry = 0;
                while (!this.fs.createNewFile(partitionContentPath) && nRetry++ < 5 && !this.fs.exists(partitionContentPath)) {
                    Thread.sleep(500L * (long)nRetry);
                }
                if (!this.fs.exists(partitionContentPath)) {
                    throw new IllegalStateException("Fail to create HDFS file: " + partitionContentPath + " after " + nRetry + " retries");
                }
            }
            this.fout = this.supportAppend ? this.fs.append(partitionContentPath) : this.fs.create(partitionContentPath);
            this.prePartitionPath = partitionPath.toString();
            this.curPartitionContentPath = partitionContentPath;
            this.id = (this.id + 1) % (this.supportAppend ? 10 : 100000);
        }
        try {
            int count = 0;
            for (HiveProducerRecord elem : recordItr) {
                this.fout.writeBytes(elem.valueToString() + "\n");
                ++count;
            }
            logger.debug("Success to write {} metrics ({}) to file {}", count, this.metricType, this.curPartitionContentPath);
        }
        catch (IOException e) {
            logger.error("Fails to write metrics(" + this.metricType + ") to file " + this.curPartitionContentPath.toString() + " due to ", e);
            this.closeFout();
        }
        if (this.closeFileEveryAppend) {
            this.closeFout();
        }
    }

    private void closeFout() {
        block5: {
            if (this.fout != null) {
                try {
                    logger.debug("Flush output stream {}.", (Object)this.curPartitionContentPath);
                    this.fout.close();
                }
                catch (Exception e) {
                    logger.error("Close the path: " + this.curPartitionContentPath + " failed", e);
                    if (!(this.fs instanceof DistributedFileSystem)) break block5;
                    DistributedFileSystem hdfs = (DistributedFileSystem)this.fs;
                    try {
                        boolean bl = hdfs.recoverLease(this.curPartitionContentPath);
                    }
                    catch (Exception e1) {
                        logger.error("Recover lease for path: " + this.curPartitionContentPath + " failed", e1);
                    }
                }
            }
        }
        this.fout = null;
    }

    HiveProducerRecord convertTo(Record record) throws Exception {
        Map<String, Object> rawValue = record.getValueRaw();
        HashMap<String, String> partitionKVs = Maps.newHashMapWithExpectedSize(1);
        partitionKVs.put(TimePropertyEnum.DAY_DATE.toString(), rawValue.get(TimePropertyEnum.DAY_DATE.toString()).toString());
        return this.parseToHiveProducerRecord(HiveReservoirReporter.getTableFromSubject(record.getSubject()), partitionKVs, rawValue);
    }

    public HiveProducerRecord parseToHiveProducerRecord(String tableName, Map<String, String> partitionKVs, Map<String, Object> rawValue) throws Exception {
        Pair<String, String> tableNameSplits = ActiveReservoirReporter.getTableNameSplits(tableName);
        List<FieldSchema> fields = this.tableFieldSchemaCache.get(tableNameSplits).getSecond();
        ArrayList<Object> columnValues = Lists.newArrayListWithExpectedSize(fields.size());
        for (FieldSchema fieldSchema : fields) {
            columnValues.add(rawValue.get(fieldSchema.getName().toUpperCase(Locale.ROOT)));
        }
        HiveProducerRecord.RecordKey key = new HiveProducerRecord.KeyBuilder(tableNameSplits.getSecond()).setDbName(tableNameSplits.getFirst()).setPartitionKVs(partitionKVs).build();
        return new HiveProducerRecord(key, columnValues);
    }
}

