/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.kafka;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaActiveReserviorListener
implements ActiveReservoirListener {
    public static final long TOPIC_AVAILABLE_TAG = 0L;
    protected static final Logger logger = LoggerFactory.getLogger(KafkaActiveReserviorListener.class);
    protected Long maxBlockMs = 1800000L;
    protected int maxRecordForLogNum = KylinConfig.getInstanceFromEnv().printSampleEventRatio();
    protected int maxRecordSkipForLogNum = 10000;
    protected ConcurrentHashMap<String, Long> topicsIfAvailable = new ConcurrentHashMap();
    private long nRecord = 0L;
    private long nRecordSkip = 0L;
    private int threshold = Integer.min((int)((double)this.maxRecordForLogNum * 0.002), 25);
    private Callback produceCallback = (metadata, exception) -> {
        if (exception != null) {
            logger.warn("Unexpected exception.", exception);
        } else {
            logger.debug("Topic:{} ; partition:{} ; offset:{} .", metadata.topic(), metadata.partition(), metadata.offset());
        }
    };

    protected abstract String decorateTopic(String var1);

    protected abstract void tryFetchMetadataFor(String var1);

    protected abstract void send(String var1, Record var2, Callback var3);

    protected void sendWrapper(String topic, Record record, Callback callback) {
        try {
            this.send(topic, record, callback);
        }
        catch (TimeoutException e) {
            this.setUnAvailable(topic);
            throw e;
        }
    }

    @Override
    public boolean onRecordUpdate(List<Record> records) {
        try {
            for (Record record : records) {
                String topic = this.decorateTopic(record.getSubject());
                if (this.nRecord <= (long)this.threshold) {
                    logger.debug("Send record {} to topic : {}", (Object)record, (Object)topic);
                }
                if (!this.checkAvailable(topic)) {
                    if (this.nRecordSkip % (long)this.maxRecordSkipForLogNum == 0L) {
                        this.nRecordSkip = 0L;
                        logger.warn("Skip to send record to topic {}", (Object)topic);
                    }
                    ++this.nRecordSkip;
                    continue;
                }
                if (this.nRecord % (long)this.maxRecordForLogNum == 0L) {
                    this.sendWrapper(topic, record, this.produceCallback);
                } else {
                    this.sendWrapper(topic, record, null);
                }
                ++this.nRecord;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return false;
        }
        return true;
    }

    protected boolean checkAvailable(String topic) {
        Long timeBlock = this.topicsIfAvailable.get(topic);
        if (timeBlock != null && timeBlock == 0L) {
            return true;
        }
        if (timeBlock == null || System.currentTimeMillis() - timeBlock > this.maxBlockMs) {
            try {
                this.tryFetchMetadataFor(topic);
                this.topicsIfAvailable.put(topic, 0L);
                return true;
            }
            catch (TimeoutException e) {
                logger.warn("Fail to fetch metadata for topic " + topic, e);
                this.setUnAvailable(topic);
                return false;
            }
        }
        return false;
    }

    protected void setUnAvailable(String topic) {
        logger.debug("Cannot find topic {}", (Object)topic);
        this.topicsIfAvailable.put(topic, System.currentTimeMillis());
    }

    public long getNRecord() {
        return this.nRecord;
    }

    public long getNRecordSkip() {
        return this.nRecordSkip;
    }
}

