/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model.stats;

import java.util.Map;
import java.util.TreeMap;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LongLatencyInfo {
    @JsonProperty(value="long_latency_segment_events")
    private Map<String, Integer> longLatencyEventCnts = new TreeMap<String, Integer>();
    @JsonProperty(value="total_long_latency_events")
    private int totalLongLatencyEventCnt;

    public Map<String, Integer> getLongLatencyEventCnts() {
        return this.longLatencyEventCnts;
    }

    public void setLongLatencyEventCnts(Map<String, Integer> longLatencyEventCnts) {
        this.longLatencyEventCnts = longLatencyEventCnts;
    }

    public int getTotalLongLatencyEventCnt() {
        return this.totalLongLatencyEventCnt;
    }

    public void setTotalLongLatencyEventCnt(int totalLongLatencyEventCnt) {
        this.totalLongLatencyEventCnt = totalLongLatencyEventCnt;
    }

    public void incLongLatencyEvent(String segmentName) {
        Integer llEventCnt = this.longLatencyEventCnts.get(segmentName);
        llEventCnt = llEventCnt == null ? Integer.valueOf(1) : Integer.valueOf(llEventCnt + 1);
        this.longLatencyEventCnts.put(segmentName, llEventCnt);
        ++this.totalLongLatencyEventCnt;
    }

    public LongLatencyInfo truncate(int maxSegments) {
        int segmentNum = this.longLatencyEventCnts.size();
        if (segmentNum <= maxSegments) {
            return this;
        }
        TreeMap<String, Integer> sortMap = new TreeMap<String, Integer>(this.longLatencyEventCnts);
        int shouldRemoved = maxSegments - segmentNum;
        for (String segmentName : sortMap.keySet()) {
            if (shouldRemoved == 0) break;
            this.longLatencyEventCnts.remove(segmentName);
            --shouldRemoved;
        }
        return this;
    }

    public String toString() {
        return "LongLatencyInfo{longLatencyEventCnts=" + this.longLatencyEventCnts + ", totalLongLatencyEventCnt=" + this.totalLongLatencyEventCnt + '}';
    }
}

