/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

public class FragmentId
implements Comparable<FragmentId> {
    private static final String SEP = "-";
    private int startId;
    private int endId;

    public static FragmentId parse(String idString) {
        String[] splits = idString.split(SEP);
        if (splits.length == 1) {
            return new FragmentId(Integer.parseInt(splits[0]));
        }
        if (splits.length == 2) {
            return new FragmentId(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
        }
        throw new IllegalArgumentException("illegal fragment id format:" + idString);
    }

    public FragmentId(int id) {
        this.startId = id;
        this.endId = id;
    }

    public FragmentId(int startId, int endId) {
        this.startId = startId;
        this.endId = endId;
    }

    public int getStartId() {
        return this.startId;
    }

    public int getEndId() {
        return this.endId;
    }

    @Override
    public int compareTo(FragmentId other) {
        return this.endId - other.endId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentId that = (FragmentId)o;
        if (this.startId != that.startId) {
            return false;
        }
        return this.endId == that.endId;
    }

    public int hashCode() {
        int result = this.startId;
        result = 31 * result + this.endId;
        return result;
    }

    public String toString() {
        if (this.startId == this.endId) {
            return String.valueOf(this.endId);
        }
        return this.startId + SEP + this.endId;
    }
}

