/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;

public class AutoDeleteDirectory
implements Closeable {
    private final File tempFile;

    public AutoDeleteDirectory(File file) {
        this.tempFile = file;
    }

    public AutoDeleteDirectory(String prefix, String suffix) {
        try {
            this.tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
            FileUtils.forceDelete(this.tempFile);
            this.tempFile.mkdirs();
        }
        catch (IOException e) {
            throw new RuntimeException("create temp file " + prefix + "****" + suffix + " failed", e);
        }
    }

    public String getAbsolutePath() {
        return this.tempFile.getAbsolutePath();
    }

    public AutoDeleteDirectory child(String child) {
        return new AutoDeleteDirectory(new File(this.tempFile, child));
    }

    public File getFile() {
        return this.tempFile;
    }

    @Override
    public void close() throws IOException {
        FileUtils.forceDelete(this.tempFile);
    }
}

