/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.transfer.DataTransferFactory;
import org.apache.hive.hcatalog.data.transfer.HCatReader;
import org.apache.hive.hcatalog.data.transfer.ReadEntity;
import org.apache.hive.hcatalog.data.transfer.ReaderContext;
import org.apache.kylin.source.IReadableTable;

public class HiveTableReader
implements IReadableTable.TableReader {
    private String dbName;
    private String tableName;
    private int currentSplit = -1;
    private ReaderContext readCntxt = null;
    private Iterator<HCatRecord> currentHCatRecordItr = null;
    private HCatRecord currentHCatRecord;
    private int numberOfSplits = 0;
    private Map<String, String> partitionKV = null;

    public HiveTableReader(String dbName, String tableName) throws IOException {
        this(dbName, tableName, null);
    }

    public HiveTableReader(String dbName, String tableName, Map<String, String> partitionKV) throws IOException {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partitionKV = partitionKV;
        this.initialize();
    }

    private void initialize() throws IOException {
        try {
            this.readCntxt = HiveTableReader.getHiveReaderContext(this.dbName, this.tableName, this.partitionKV);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        this.numberOfSplits = this.readCntxt.numSplits();
    }

    @Override
    public boolean next() throws IOException {
        while (this.currentHCatRecordItr == null || !this.currentHCatRecordItr.hasNext()) {
            ++this.currentSplit;
            if (this.currentSplit == this.numberOfSplits) {
                return false;
            }
            this.currentHCatRecordItr = HiveTableReader.loadHCatRecordItr(this.readCntxt, this.currentSplit);
        }
        this.currentHCatRecord = this.currentHCatRecordItr.next();
        return true;
    }

    @Override
    public String[] getRow() {
        return HiveTableReader.getRowAsStringArray(this.currentHCatRecord);
    }

    public List<String> getRowAsList() {
        return HiveTableReader.getRowAsList(this.currentHCatRecord);
    }

    public static List<String> getRowAsList(HCatRecord record, List<String> rowValues) {
        List allFields = record.getAll();
        for (Object o : allFields) {
            rowValues.add(o == null ? null : o.toString());
        }
        return rowValues;
    }

    public static List<String> getRowAsList(HCatRecord record) {
        return Arrays.asList(HiveTableReader.getRowAsStringArray(record));
    }

    public static String[] getRowAsStringArray(HCatRecord record) {
        String[] arr = new String[record.size()];
        for (int i = 0; i < arr.length; ++i) {
            Object o = record.get(i);
            arr[i] = o == null || "\\N".equals(o) ? null : o.toString();
        }
        return arr;
    }

    @Override
    public void close() throws IOException {
        this.readCntxt = null;
        this.currentHCatRecordItr = null;
        this.currentHCatRecord = null;
        this.currentSplit = -1;
    }

    public String toString() {
        return "hive table reader for: " + this.dbName + "." + this.tableName;
    }

    private static ReaderContext getHiveReaderContext(String database, String table, Map<String, String> partitionKV) throws Exception {
        HiveConf hiveConf = new HiveConf(HiveTableReader.class);
        Iterator itr = hiveConf.iterator();
        HashMap map = new HashMap();
        while (itr.hasNext()) {
            Map.Entry kv = (Map.Entry)itr.next();
            map.put(kv.getKey(), kv.getValue());
        }
        ReadEntity entity = partitionKV == null || partitionKV.size() == 0 ? new ReadEntity.Builder().withDatabase(database).withTable(table).build() : new ReadEntity.Builder().withDatabase(database).withTable(table).withPartition(partitionKV).build();
        HCatReader reader = DataTransferFactory.getHCatReader((ReadEntity)entity, map);
        ReaderContext cntxt = reader.prepareRead();
        return cntxt;
    }

    private static Iterator<HCatRecord> loadHCatRecordItr(ReaderContext readCntxt, int dataSplit) throws HCatException {
        HCatReader currentHCatReader = DataTransferFactory.getHCatReader((ReaderContext)readCntxt, (int)dataSplit);
        return currentHCatReader.read();
    }
}

