/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
CREATE TABLE EVENT_ATTRIBUTE
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  CATALOG_ID VARCHAR(64) NOT NULL,
  NAME VARCHAR(64) NOT NULL,
  DISPLAY_NAME VARCHAR(64) NOT NULL,
  DESCRIPTION VARCHAR(1024),
  DATATYPE VARCHAR(64),
  INDEXED CHAR,
  SORTABLE CHAR,
  REQUIRED CHAR,
  REQUEST_CONTEXT CHAR
);

CREATE UNIQUE INDEX ATTRIBUTE_NAME ON EVENT_ATTRIBUTE(NAME);

CREATE TABLE ATTRIBUTE_EXAMPLES
(
  ATTRIBUTE_ID BIGINT NOT NULL,
  EXAMPLE VARCHAR(64),
  FOREIGN KEY (ATTRIBUTE_ID) REFERENCES EVENT_ATTRIBUTE(ID),
);

CREATE TABLE ATTRIBUTE_ALIASES
(
  ATTRIBUTE_ID BIGINT NOT NULL,
  ALIAS VARCHAR(64),
  FOREIGN KEY (ATTRIBUTE_ID) REFERENCES EVENT_ATTRIBUTE(ID),
);

CREATE TABLE ATTRIBUTE_CONSTRAINT
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  ATTRIBUTE_ID BIGINT NOT NULL,
  CONSTRAINT_TYPE VARCHAR(32) NOT NULL,
  VALUE VARCHAR(256),
  FOREIGN KEY (ATTRIBUTE_ID) REFERENCES EVENT_ATTRIBUTE(ID),
);

CREATE TABLE CATALOG_EVENT
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  CATALOG_ID VARCHAR(64) NOT NULL,
  NAME VARCHAR(64) NOT NULL,
  DISPLAY_NAME VARCHAR(64) NOT NULL,
  DESCRIPTION VARCHAR(1024)
);

CREATE UNIQUE INDEX EVENT_NAME ON CATALOG_EVENT(NAME);

CREATE TABLE EVENT_ALIASES
(
  EVENT_ID BIGINT NOT NULL,
  ALIAS VARCHAR(64) NOT NULL,
  FOREIGN KEY  (EVENT_ID) REFERENCES CATALOG_EVENT(ID),
);

CREATE TABLE EVENT_ATTRIBUTES
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  EVENT_ID BIGINT NOT NULL,
  ATTRIBUTE_ID BIGINT NOT NULL,
  IS_REQUIRED CHAR,
  FOREIGN KEY (EVENT_ID) REFERENCES CATALOG_EVENT(ID),
  FOREIGN KEY (ATTRIBUTE_ID) REFERENCES EVENT_ATTRIBUTE(ID)
);

CREATE TABLE CATALOG_CATEGORY
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  CATALOG_ID VARCHAR(64) NOT NULL,
  NAME VARCHAR(64) NOT NULL,
  DISPLAY_NAME VARCHAR(64) NOT NULL,
  DESCRIPTION VARCHAR(1024)

);

CREATE UNIQUE INDEX CATEGORY_NAME ON CATALOG_CATEGORY(NAME);

CREATE TABLE CATEGORY_EVENTS
(
  CATEGORY_ID BIGINT NOT NULL,
  EVENT_ID BIGINT NOT NULL,
  FOREIGN KEY (CATEGORY_ID) REFERENCES CATALOG_CATEGORY(ID),
  FOREIGN KEY (EVENT_ID) REFERENCES CATALOG_EVENT(ID)
);

CREATE TABLE CATALOG_PRODUCT
(
  ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  CATALOG_ID VARCHAR(64) NOT NULL,
  NAME VARCHAR(64) NOT NULL,
  DISPLAY_NAME VARCHAR(64) NOT NULL,
  DESCRIPTION VARCHAR(1024)

);

CREATE UNIQUE INDEX PRODUCT_NAME ON CATALOG_PRODUCT(NAME);

CREATE TABLE PRODUCT_EVENTS
(
  PRODUCT_ID BIGINT NOT NULL,
  EVENT_ID BIGINT NOT NULL,
  FOREIGN KEY (PRODUCT_ID) REFERENCES CATALOG_PRODUCT(ID),
  FOREIGN KEY (EVENT_ID) REFERENCES CATALOG_EVENT(ID)
);