/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup;

import java.nio.charset.Charset;
import org.jline.terminal.Terminal;

public enum ConsoleIcon {
    SUCCESS('\u2713', "[OK]"),
    ERROR('\u2717', "[ERROR]"),
    WARNING('\u26a0', "[WARNING]"),
    DETAIL('\u2022', "-"),
    ACTION('\u2192', ">");

    private final char unicodeChar;
    private final String asciiFallback;

    private ConsoleIcon(char unicodeChar, String asciiFallback) {
        this.unicodeChar = unicodeChar;
        this.asciiFallback = asciiFallback;
    }

    public String getIcon(Terminal terminal) {
        Charset charset = ConsoleIcon.getTerminalCharset(terminal);
        return charset.newEncoder().canEncode(this.unicodeChar) ? String.valueOf(this.unicodeChar) : this.asciiFallback;
    }

    private static Charset getTerminalCharset(Terminal terminal) {
        if (terminal != null && terminal.encoding() != null) {
            return terminal.encoding();
        }
        return Charset.defaultCharset();
    }

    public char getUnicodeChar() {
        return this.unicodeChar;
    }

    public String getAsciiFallback() {
        return this.asciiFallback;
    }
}

