/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public record UpgradeResult(Set<Path> processedPoms, Set<Path> modifiedPoms, Set<Path> errorPoms) {
    public UpgradeResult {
        processedPoms = Set.copyOf(processedPoms);
        modifiedPoms = Set.copyOf(modifiedPoms);
        errorPoms = Set.copyOf(errorPoms);
    }

    public static UpgradeResult success(Set<Path> processedPoms, Set<Path> modifiedPoms) {
        return new UpgradeResult(processedPoms, modifiedPoms, Collections.emptySet());
    }

    public static UpgradeResult failure(Set<Path> processedPoms, Set<Path> errorPoms) {
        return new UpgradeResult(processedPoms, Collections.emptySet(), errorPoms);
    }

    public static UpgradeResult empty() {
        return new UpgradeResult(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public UpgradeResult merge(UpgradeResult other) {
        HashSet<Path> mergedProcessed = new HashSet<Path>(this.processedPoms);
        mergedProcessed.addAll(other.processedPoms);
        HashSet<Path> mergedModified = new HashSet<Path>(this.modifiedPoms);
        mergedModified.addAll(other.modifiedPoms);
        HashSet<Path> mergedErrors = new HashSet<Path>(this.errorPoms);
        mergedErrors.addAll(other.errorPoms);
        return new UpgradeResult(mergedProcessed, mergedModified, mergedErrors);
    }

    public boolean success() {
        return this.errorPoms.isEmpty();
    }

    public int processedCount() {
        return this.processedPoms.size();
    }

    public int modifiedCount() {
        return this.modifiedPoms.size();
    }

    public int errorCount() {
        return this.errorPoms.size();
    }

    public int unmodifiedCount() {
        HashSet<Path> unmodified = new HashSet<Path>(this.processedPoms);
        unmodified.removeAll(this.modifiedPoms);
        unmodified.removeAll(this.errorPoms);
        return unmodified.size();
    }
}

