/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginContainer
implements Serializable,
InputLocationTracker {
    final List<Plugin> plugins;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;
    volatile Map<String, Plugin> pluginMap;

    protected PluginContainer(Builder builder) {
        this.plugins = ImmutableCollections.copy(builder.plugins != null ? builder.plugins : (builder.base != null ? builder.base.plugins : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return PluginContainer.newBuilder(this);
    }

    @Nonnull
    public PluginContainer withPlugins(Collection<Plugin> plugins) {
        return PluginContainer.newBuilder(this, true).plugins(plugins).build();
    }

    @Nonnull
    public static PluginContainer newInstance() {
        return PluginContainer.newInstance(true);
    }

    @Nonnull
    public static PluginContainer newInstance(boolean withDefaults) {
        return PluginContainer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginContainer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from) {
        return PluginContainer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Plugin> getPluginsAsMap() {
        if (this.pluginMap == null) {
            PluginContainer pluginContainer = this;
            synchronized (pluginContainer) {
                if (this.pluginMap == null) {
                    this.pluginMap = ImmutableCollections.copy(this.plugins.stream().collect(Collectors.toMap(Plugin::getKey, Function.identity())));
                }
            }
        }
        return this.pluginMap;
    }

    public String toString() {
        return "PluginContainer {}";
    }

    @NotThreadSafe
    public static class Builder {
        PluginContainer base;
        Collection<Plugin> plugins;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(PluginContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.plugins = base.plugins;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PluginContainer build() {
            if (this.base != null && (this.plugins == null || this.plugins == this.base.plugins)) {
                return this.base;
            }
            return new PluginContainer(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

