/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.it;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

/**
 * This is a test set for <a href="https://issues.apache.org/jira/browse/MNG-4618">MNG-4618</a>.
 *
 * @author Benjamin Bentmann
 */
public class MavenITmng4618AggregatorBuiltAfterModulesTest extends AbstractMavenIntegrationTestCase {

    public MavenITmng4618AggregatorBuiltAfterModulesTest() {
        super("[2.0.3,3.0-alpha-1),[3.0-beta-1,)");
    }

    /**
     * Verify that aggregator-only projects (i.e. not used as parent for inheritance) get built after their modules.
     *
     * @throws Exception in case of failure
     */
    @Test
    public void testit() throws Exception {
        File testDir = extractResources("/mng-4618");

        Verifier verifier = newVerifier(testDir.getAbsolutePath());
        verifier.setAutoclean(false);
        verifier.deleteDirectory("target");
        verifier.addCliArgument("validate");
        verifier.execute();
        verifier.verifyErrorFreeLog();

        List<String> mods = verifier.loadLines("target/log.txt");
        assertEquals(Arrays.asList(new String[] {"mod-a", "mod-b", "mod-c", "aggregator"}), mods);
    }
}
