/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import org.apache.ftpserver.ftplet.FtpRequest;

public class DefaultFtpRequest
implements FtpRequest {
    private final String line;
    private final String command;
    private final String argument;
    private final long receivedTime = System.currentTimeMillis();

    public DefaultFtpRequest(String requestLine) {
        this.line = requestLine.trim();
        int spInd = this.line.indexOf(32);
        this.command = this.parseCmd(this.line, spInd);
        this.argument = this.parseArg(this.line, spInd);
    }

    private String parseCmd(String lineToParse, int spInd) {
        String cmd = null;
        cmd = spInd != -1 ? this.line.substring(0, spInd).toUpperCase() : this.line.toUpperCase();
        if (cmd.length() > 0 && cmd.charAt(0) == 'X') {
            cmd = cmd.substring(1);
        }
        return cmd;
    }

    private String parseArg(String lineToParse, int spInd) {
        String arg = null;
        if (spInd != -1 && (arg = this.line.substring(spInd + 1)).equals("")) {
            arg = null;
        }
        return arg;
    }

    public String getCommand() {
        return this.command;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getRequestLine() {
        return this.line;
    }

    public boolean hasArgument() {
        return this.getArgument() != null;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public String toString() {
        return this.getRequestLine();
    }
}

