/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ContinueRecord
extends Record {
    public static final short sid = 60;
    private byte[] field_1_data;

    public ContinueRecord() {
    }

    public ContinueRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ContinueRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public byte[] serialize() {
        byte[] retval = new byte[this.field_1_data.length + 4];
        this.serialize(0, retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)60);
        LittleEndian.putShort(data, offset + 2, (short)this.field_1_data.length);
        System.arraycopy(this.field_1_data, 0, data, offset + 4, this.field_1_data.length);
        return this.field_1_data.length + 4;
    }

    public void setData(byte[] data) {
        this.field_1_data = data;
    }

    public byte[] getData() {
        return this.field_1_data;
    }

    public static byte[] processContinue(byte[] data) {
        int cr;
        int records = data.length / 8214;
        int offset = 8214;
        ArrayList<byte[]> crs = new ArrayList<byte[]>(records);
        int totalsize = 8214;
        byte[] retval = null;
        for (cr = 0; cr < records; ++cr) {
            ContinueRecord contrec = new ContinueRecord();
            int arraysize = Math.min(8210, data.length - offset);
            byte[] crdata = new byte[arraysize];
            System.arraycopy(data, offset, crdata, 0, arraysize);
            offset += crdata.length;
            contrec.setData(crdata);
            crs.add(contrec.serialize());
        }
        for (cr = 0; cr < records; ++cr) {
            totalsize += ((byte[])crs.get(cr)).length;
        }
        retval = new byte[totalsize];
        offset = 8214;
        System.arraycopy(data, 0, retval, 0, 8214);
        for (cr = 0; cr < records; ++cr) {
            byte[] src = (byte[])crs.get(cr);
            System.arraycopy(src, 0, retval, offset, src.length);
            offset += src.length;
        }
        return retval;
    }

    protected void fillFields(byte[] ignored_parm1, short ignored_parm2) {
        this.field_1_data = ignored_parm1;
    }

    protected void validateSid(short id) {
        if (id != 60) {
            throw new RecordFormatException("Not a Continue Record");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CONTINUE RECORD]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(60)).append("\n");
        buffer.append("[/CONTINUE RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 60;
    }

    protected void fillFields(byte[] ignored_parm1, short ignored_parm2, int ignored_parm3) {
    }

    public Object clone() {
        ContinueRecord clone = new ContinueRecord();
        clone.setData(this.field_1_data);
        return clone;
    }
}

