/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractThreadSafeAttributeMap
extends AbstractMap {
    private Set _keySet;
    private Collection _values;
    private Set _entrySet;

    public void clear() {
        ArrayList names = this._list(this.getAttributeNames());
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.removeAttribute((String)it.next());
        }
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            Object value = this.getAttribute((String)e.nextElement());
            if (!findValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return this._entrySet != null ? this._entrySet : (this._entrySet = new EntrySet());
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public Set keySet() {
        return this._keySet != null ? this._keySet : (this._keySet = new KeySet());
    }

    public Object put(Object key, Object value) {
        String key_ = key.toString();
        Object retval = this.getAttribute(key_);
        this.setAttribute(key_, value);
        return retval;
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.setAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        String key_ = key.toString();
        Object retval = this.getAttribute(key_);
        this.removeAttribute(key_);
        return retval;
    }

    public int size() {
        int size = 0;
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            ++size;
            e.nextElement();
        }
        return size;
    }

    public Collection values() {
        return this._values != null ? this._values : (this._values = new Values());
    }

    private ArrayList _list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration getAttributeNames();

    private class EntrySetEntry
    implements Map.Entry {
        private final Object _currentKey;

        public EntrySetEntry(Object currentKey) {
            this._currentKey = currentKey;
        }

        public Object getKey() {
            return this._currentKey;
        }

        public Object getValue() {
            return AbstractThreadSafeAttributeMap.this.get(this._currentKey);
        }

        public Object setValue(Object value) {
            return AbstractThreadSafeAttributeMap.this.put(this._currentKey, value);
        }

        public int hashCode() {
            return this._currentKey == null ? 0 : this._currentKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntrySetEntry)) {
                return false;
            }
            return this._currentKey != null && this._currentKey.equals(obj);
        }
    }

    private class EntryIterator
    extends KeyIterator {
        private EntryIterator() {
        }

        public Object next() {
            super.next();
            return new EntrySetEntry(this._currentKey);
        }
    }

    private class EntrySet
    extends KeySet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(AbstractThreadSafeAttributeMap.this.get(key));
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(AbstractThreadSafeAttributeMap.this.get(key))) {
                return false;
            }
            return AbstractThreadSafeAttributeMap.this.remove(((Map.Entry)o).getKey()) != null;
        }
    }

    private class ValuesIterator
    extends KeyIterator {
        private ValuesIterator() {
        }

        public Object next() {
            super.next();
            return AbstractThreadSafeAttributeMap.this.get(this._currentKey);
        }
    }

    private class Values
    extends KeySet {
        private Values() {
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public boolean contains(Object o) {
            return AbstractThreadSafeAttributeMap.this.containsValue(o);
        }

        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    private class KeyIterator
    implements Iterator {
        protected final Iterator _i;
        protected Object _currentKey;

        private KeyIterator() {
            this._i = AbstractThreadSafeAttributeMap.this._list(AbstractThreadSafeAttributeMap.this.getAttributeNames()).iterator();
        }

        public void remove() {
            if (this._currentKey == null) {
                throw new NoSuchElementException("You must call next() at least once");
            }
            AbstractThreadSafeAttributeMap.this.remove(this._currentKey);
        }

        public boolean hasNext() {
            return this._i.hasNext();
        }

        public Object next() {
            this._currentKey = this._i.next();
            return this._currentKey;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean isEmpty() {
            return AbstractThreadSafeAttributeMap.this.isEmpty();
        }

        public int size() {
            return AbstractThreadSafeAttributeMap.this.size();
        }

        public boolean contains(Object o) {
            return AbstractThreadSafeAttributeMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return AbstractThreadSafeAttributeMap.this.remove(o) != null;
        }

        public void clear() {
            AbstractThreadSafeAttributeMap.this.clear();
        }
    }
}

