/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.StateCache;
import org.apache.myfaces.application.viewstate.CounterKeyFactory;
import org.apache.myfaces.application.viewstate.CounterSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.application.viewstate.RandomKeyFactory;
import org.apache.myfaces.application.viewstate.RandomSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.SecureRandomKeyFactory;
import org.apache.myfaces.application.viewstate.SerializedViewCollection;
import org.apache.myfaces.application.viewstate.SerializedViewKey;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactory;
import org.apache.myfaces.shared.util.MyFacesObjectInputStream;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerSideStateCacheImpl
extends StateCache<Object, Object> {
    private static final Logger log = Logger.getLogger(ServerSideStateCacheImpl.class.getName());
    public static final String SERIALIZED_VIEW_SESSION_ATTR = ServerSideStateCacheImpl.class.getName() + ".SERIALIZED_VIEW";
    public static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    public static final String RESTORED_VIEW_KEY_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_VIEW_KEY";
    public static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final String NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION";
    public static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    public static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    public static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    public static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    public static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE = "org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE";
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT = "hard-soft";
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT = "soft";
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK = "soft-weak";
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK = "weak";
    public static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF = "off";
    public static final String USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION = "org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_NONE = "none";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_RANDOM = "random";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM_DEFAULT = "secureRandom";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH";
    public static final int RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH_PARAM_DEFAULT = 8;
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM";
    public static final int UNCOMPRESSED_FLAG = 0;
    public static final int COMPRESSED_FLAG = 1;
    private Boolean _useFlashScopePurgeViewsInSession = null;
    private Integer _numberOfSequentialViewsInSession = null;
    private boolean _numberOfSequentialViewsInSessionSet = false;
    private SessionViewStorageFactory sessionViewStorageFactory;

    public ServerSideStateCacheImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String randomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM, "secureRandom");
        this.sessionViewStorageFactory = RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_RANDOM.equals(randomMode) ? new RandomSessionViewStorageFactory(new RandomKeyFactory(facesContext)) : (RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_NONE.equals(randomMode) ? new CounterSessionViewStorageFactory(new CounterKeyFactory()) : new RandomSessionViewStorageFactory(new SecureRandomKeyFactory(facesContext)));
    }

    protected Object getServerStateId(FacesContext facesContext, Object state) {
        if (state != null) {
            return this.getKeyFactory(facesContext).decode(state);
        }
        return null;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, Object serializedView) {
        Map<String, Object> sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = this.getSessionViewStorageFactory().createSerializedViewCollection(context);
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        Map<Object, Object> attributeMap = context.getAttributes();
        SerializedViewKey key = null;
        if (this.getNumberOfSequentialViewsInSession(context.getExternalContext()) != null && this.getNumberOfSequentialViewsInSession(context.getExternalContext()) > 0 && (key = (SerializedViewKey)attributeMap.get(RESTORED_VIEW_KEY_REQUEST_ATTR)) == null && this.isUseFlashScopePurgeViewsInSession(context.getExternalContext()) && Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get("oam.Flash.REDIRECT.PREVIOUSREQUEST"))) {
            key = (SerializedViewKey)context.getExternalContext().getFlash().get(RESTORED_VIEW_KEY_REQUEST_ATTR);
        }
        SerializedViewKey nextKey = this.getSessionViewStorageFactory().createSerializedViewKey(context, context.getViewRoot().getViewId(), this.getNextViewSequence(context));
        viewCollection.add(context, this.serializeView(context, serializedView), nextKey, key);
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Object sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map<Object, Object> attributeMap = context.getAttributes();
        Object serializedView = null;
        if (attributeMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = attributeMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence))) != null) {
                serializedView = this.deserializeView(state);
            }
            attributeMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (this.getNumberOfSequentialViewsInSession(externalContext) != null && this.getNumberOfSequentialViewsInSession(externalContext) > 0) {
                SerializedViewKey key = this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence);
                attributeMap.put(RESTORED_VIEW_KEY_REQUEST_ATTR, key);
                if (this.isUseFlashScopePurgeViewsInSession(externalContext)) {
                    externalContext.getFlash().put(RESTORED_VIEW_KEY_REQUEST_ATTR, key);
                    externalContext.getFlash().keep(RESTORED_VIEW_KEY_REQUEST_ATTR);
                }
            }
            this.nextViewSequence(context);
        }
        return serializedView;
    }

    public Object getNextViewSequence(FacesContext context) {
        Object sequence = context.getAttributes().get("jsf_sequence");
        if (sequence == null) {
            sequence = this.nextViewSequence(context);
            context.getAttributes().put("jsf_sequence", sequence);
        }
        return sequence;
    }

    public Object nextViewSequence(FacesContext facescontext) {
        Object sequence = this.getKeyFactory(facescontext).generateKey(facescontext);
        facescontext.getAttributes().put("jsf_sequence", sequence);
        return sequence;
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(serializedView);
                out.close();
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = Boolean.valueOf(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = Boolean.valueOf(value);
        }
        return compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object object;
            block15: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream ois = null;
                try {
                    MyFacesObjectInputStream in;
                    ois = in = new MyFacesObjectInputStream(is);
                    Object object2 = null;
                    object2 = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return in.readObject();
                        }
                    }) : in.readObject();
                    object = object2;
                    if (ois == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return object;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass());
        return null;
    }

    @Override
    public Object saveSerializedView(FacesContext facesContext, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing saveSerializedView - server-side state saving - save state");
        }
        this.saveSerializedViewInServletSession(facesContext, serializedView);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting saveSerializedView - server-side state saving - saved state");
        }
        return this.encodeSerializedState(facesContext, serializedView);
    }

    @Override
    public Object restoreSerializedView(FacesContext facesContext, String viewId, Object viewState) {
        Object serverStateId;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Restoring view from session");
        }
        return (serverStateId = this.getServerStateId(facesContext, viewState)) == null ? null : this.getSerializedViewFromServletSession(facesContext, viewId, serverStateId);
    }

    @Override
    public Object encodeSerializedState(FacesContext facesContext, Object serializedView) {
        return this.getKeyFactory(facesContext).encode(this.getNextViewSequence(facesContext));
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return false;
    }

    private boolean isUseFlashScopePurgeViewsInSession(ExternalContext externalContext) {
        if (this._useFlashScopePurgeViewsInSession == null) {
            this._useFlashScopePurgeViewsInSession = WebConfigParamUtils.getBooleanInitParameter(externalContext, USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION, false);
        }
        return this._useFlashScopePurgeViewsInSession;
    }

    private Integer getNumberOfSequentialViewsInSession(ExternalContext externalContext) {
        if (!this._numberOfSequentialViewsInSessionSet) {
            this._numberOfSequentialViewsInSession = WebConfigParamUtils.getIntegerInitParameter(externalContext, NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_PARAM);
            this._numberOfSequentialViewsInSessionSet = true;
        }
        return this._numberOfSequentialViewsInSession;
    }

    protected KeyFactory getKeyFactory(FacesContext facesContext) {
        return this.sessionViewStorageFactory.getKeyFactory();
    }

    protected SessionViewStorageFactory getSessionViewStorageFactory() {
        return this.sessionViewStorageFactory;
    }
}

