/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.el.ELException;
import javax.faces.application.FacesMessage;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.apache.myfaces.view.facelets.compiler.AddFacesMessageInstruction;
import org.apache.myfaces.view.facelets.compiler.AttributeInstruction;
import org.apache.myfaces.view.facelets.compiler.BodyEndElementInstruction;
import org.apache.myfaces.view.facelets.compiler.CommentInstruction;
import org.apache.myfaces.view.facelets.compiler.CompilationUnit;
import org.apache.myfaces.view.facelets.compiler.CompositeTextInstruction;
import org.apache.myfaces.view.facelets.compiler.EndElementInstruction;
import org.apache.myfaces.view.facelets.compiler.Instruction;
import org.apache.myfaces.view.facelets.compiler.LiteralAttributeInstruction;
import org.apache.myfaces.view.facelets.compiler.LiteralCommentInstruction;
import org.apache.myfaces.view.facelets.compiler.LiteralNonExcapedTextInstruction;
import org.apache.myfaces.view.facelets.compiler.LiteralTextInstruction;
import org.apache.myfaces.view.facelets.compiler.LiteralXMLInstruction;
import org.apache.myfaces.view.facelets.compiler.StartElementInstruction;
import org.apache.myfaces.view.facelets.compiler.TextInstruction;
import org.apache.myfaces.view.facelets.compiler.UIInstructionHandler;
import org.apache.myfaces.view.facelets.compiler.XMLInstruction;
import org.apache.myfaces.view.facelets.el.ELText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TextUnit
extends CompilationUnit {
    private final StringBuffer buffer;
    private final StringBuffer textBuffer;
    private final List<Instruction> instructionBuffer;
    private final Stack<Tag> tags;
    private final List<Object> children;
    private boolean startTagOpen;
    private final String alias;
    private final String id;
    private final List<Object> messages;
    private final boolean escapeInlineText;
    private final boolean compressSpaces;

    public TextUnit(String alias, String id) {
        this(alias, id, true);
    }

    public TextUnit(String alias, String id, boolean escapeInlineText) {
        this(alias, id, escapeInlineText, false);
    }

    public TextUnit(String alias, String id, boolean escapeInlineText, boolean compressSpaces) {
        this.alias = alias;
        this.id = id;
        this.buffer = new StringBuffer();
        this.textBuffer = new StringBuffer();
        this.instructionBuffer = new ArrayList<Instruction>();
        this.tags = new Stack();
        this.children = new ArrayList<Object>();
        this.startTagOpen = false;
        this.messages = new ArrayList<Object>(4);
        this.escapeInlineText = escapeInlineText;
        this.compressSpaces = compressSpaces;
    }

    @Override
    public FaceletHandler createFaceletHandler() {
        this.flushBufferToConfig(true);
        if (this.children.size() == 0) {
            return LEAF;
        }
        FaceletHandler[] h = new FaceletHandler[this.children.size()];
        for (int i = 0; i < h.length; ++i) {
            Object obj = this.children.get(i);
            h[i] = obj instanceof FaceletHandler ? (FaceletHandler)obj : ((CompilationUnit)obj).createFaceletHandler();
        }
        if (h.length == 1) {
            return h[0];
        }
        return new CompositeFaceletHandler(h);
    }

    private void addInstruction(Instruction instruction) {
        this.flushTextBuffer(false);
        this.instructionBuffer.add(instruction);
    }

    private void flushTextBuffer(boolean child) {
        if (this.textBuffer.length() > 0) {
            String s = this.textBuffer.toString();
            if (child) {
                s = TextUnit.trimRight(s);
            }
            if (s.length() > 0) {
                if (!this.compressSpaces) {
                    ELText txt = ELText.parse(s);
                    if (txt != null) {
                        if (txt.isLiteral()) {
                            if (this.escapeInlineText) {
                                this.instructionBuffer.add(new LiteralTextInstruction(txt.toString()));
                            } else {
                                this.instructionBuffer.add(new LiteralNonExcapedTextInstruction(txt.toString()));
                            }
                        } else if (this.escapeInlineText) {
                            this.instructionBuffer.add(new TextInstruction(this.alias, txt));
                        } else {
                            ELText[] splitText = ELText.parseAsArray(s);
                            if (splitText.length > 1) {
                                Instruction[] array = new Instruction[splitText.length];
                                for (int i = 0; i < splitText.length; ++i) {
                                    ELText selText = splitText[i];
                                    array[i] = selText.isLiteral() ? new LiteralNonExcapedTextInstruction(selText.toString()) : new TextInstruction(this.alias, selText);
                                }
                                this.instructionBuffer.add(new CompositeTextInstruction(array));
                            } else {
                                this.instructionBuffer.add(new TextInstruction(this.alias, txt));
                            }
                        }
                    }
                } else if (s != null && s.length() > 0) {
                    if (ELText.isLiteral(s)) {
                        if (this.escapeInlineText) {
                            this.instructionBuffer.add(new LiteralTextInstruction(s));
                        } else {
                            this.instructionBuffer.add(new LiteralNonExcapedTextInstruction(s));
                        }
                    } else {
                        ELText[] splitText;
                        if (this.instructionBuffer.size() > 0 && !(this.instructionBuffer.get(this.instructionBuffer.size() - 1) instanceof LiteralXMLInstruction)) {
                            s = TextUnit.compressELText(s);
                        }
                        if ((splitText = ELText.parseAsArray(s)).length > 1) {
                            Instruction[] array = new Instruction[splitText.length];
                            for (int i = 0; i < splitText.length; ++i) {
                                ELText selText = splitText[i];
                                array[i] = selText.isLiteral() ? new LiteralNonExcapedTextInstruction(selText.toString()) : new TextInstruction(this.alias, selText);
                            }
                            this.instructionBuffer.add(new CompositeTextInstruction(array));
                        } else {
                            this.instructionBuffer.add(new TextInstruction(this.alias, ELText.parse(s)));
                        }
                    }
                }
            }
        }
        this.textBuffer.setLength(0);
    }

    public void write(String text) {
        this.finishStartTag();
        this.textBuffer.append(text);
        this.buffer.append(text);
    }

    public void writeInstruction(String text) {
        this.finishStartTag();
        ELText el = ELText.parse(text);
        if (el.isLiteral()) {
            this.addInstruction(new LiteralXMLInstruction(text));
        } else {
            this.addInstruction(new XMLInstruction(el));
        }
        this.buffer.append(text);
    }

    public void writeComment(String text) {
        this.finishStartTag();
        ELText el = ELText.parse(text);
        if (el.isLiteral()) {
            this.addInstruction(new LiteralCommentInstruction(text));
        } else {
            this.addInstruction(new CommentInstruction(el));
        }
        this.buffer.append("<!--" + text + "-->");
    }

    public void startTag(Tag tag) {
        this.finishStartTag();
        this.tags.push(tag);
        this.buffer.append('<');
        this.buffer.append(tag.getQName());
        this.addInstruction(new StartElementInstruction(tag.getQName()));
        TagAttribute[] attrs = tag.getAttributes().getAll();
        if (attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                String qname = attrs[i].getQName();
                String value = attrs[i].getValue();
                this.buffer.append(' ').append(qname).append("=\"").append(value).append("\"");
                ELText txt = ELText.parseAllowEmptyString(value);
                if (txt == null) continue;
                if (txt.isLiteral()) {
                    this.addInstruction(new LiteralAttributeInstruction(qname, txt.toString()));
                    continue;
                }
                this.addInstruction(new AttributeInstruction(this.alias, qname, txt));
            }
        }
        if (!this.messages.isEmpty()) {
            Iterator<Object> it = this.messages.iterator();
            while (it.hasNext()) {
                Object[] message = (Object[])it.next();
                this.addInstruction(new AddFacesMessageInstruction((FacesMessage.Severity)message[0], (String)message[1], (String)message[2]));
                it.remove();
            }
        }
        this.startTagOpen = true;
    }

    private void finishStartTag() {
        if (this.tags.size() > 0 && this.startTagOpen) {
            this.buffer.append(">");
            this.startTagOpen = false;
        }
    }

    public void endTag() {
        Tag tag = this.tags.pop();
        if ("body".equalsIgnoreCase(tag.getQName())) {
            this.addInstruction(new BodyEndElementInstruction(tag.getQName()));
        } else {
            this.addInstruction(new EndElementInstruction(tag.getQName()));
        }
        if (this.startTagOpen) {
            this.buffer.append("/>");
            this.startTagOpen = false;
        } else {
            this.buffer.append("</").append(tag.getQName()).append('>');
        }
    }

    @Override
    public void addChild(CompilationUnit unit) {
        this.finishStartTag();
        this.flushBufferToConfig(true);
        this.children.add(unit);
    }

    protected void flushBufferToConfig(boolean child) {
        this.flushTextBuffer(child);
        int size = this.instructionBuffer.size();
        if (size > 0) {
            try {
                ELText txt;
                String s = this.buffer.toString();
                if (child) {
                    s = TextUnit.trimRight(s);
                }
                if ((txt = ELText.parse(s)) != null) {
                    if (this.compressSpaces) {
                        size = TextUnit.compressSpaces(this.instructionBuffer, size);
                    }
                    Instruction[] instructions = this.instructionBuffer.toArray(new Instruction[size]);
                    this.children.add(new UIInstructionHandler(this.alias, this.id, instructions, txt));
                    this.instructionBuffer.clear();
                }
            }
            catch (ELException e) {
                if (this.tags.size() > 0) {
                    throw new TagException(this.tags.peek(), e.getMessage());
                }
                throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
            }
        }
        this.buffer.setLength(0);
    }

    public boolean isClosed() {
        return this.tags.empty();
    }

    private static final String trimRight(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i >= 0) {
            return s;
        }
        return "";
    }

    static final String compressELText(String text) {
        int firstCharLocation = -1;
        int leftChar = 0;
        int lenght = text.length();
        String leftText = null;
        for (int j = 0; j < lenght; ++j) {
            char c = text.charAt(j);
            if (leftChar == 0) {
                if (c == '\r') {
                    leftChar = 2;
                    if (j + 1 < lenght && text.charAt(j + 1) == '\n') {
                        leftChar = 3;
                    }
                }
                if (c == '\n') {
                    leftChar = 1;
                }
            }
            if (Character.isWhitespace(c)) continue;
            firstCharLocation = j;
            break;
        }
        if (firstCharLocation == -1) {
            firstCharLocation = lenght;
        }
        if (firstCharLocation > 0) {
            switch (leftChar) {
                case 1: {
                    leftText = "\n";
                    break;
                }
                case 2: {
                    leftText = "\r";
                    break;
                }
                case 3: {
                    leftText = "\r\n";
                    break;
                }
                default: {
                    leftText = lenght > 1 ? text.substring(0, 1) : text;
                    break;
                }
            }
        } else {
            leftText = "";
        }
        int lastCharLocation = TextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
        if (firstCharLocation == 0 && lastCharLocation == text.length() - 1) {
            return text;
        }
        if (lastCharLocation + 1 < text.length()) {
            ++lastCharLocation;
        }
        if (firstCharLocation == 0) {
            return text.substring(firstCharLocation, lastCharLocation + 1);
        }
        return leftText + text.substring(firstCharLocation, lastCharLocation + 1);
    }

    static final int compressSpaces(List<Instruction> instructionBuffer, int size) {
        boolean addleftspace = true;
        boolean addrightspace = false;
        boolean skipnext = false;
        for (int i = 0; i < size; ++i) {
            String text = null;
            String newText = null;
            int instructionType = 0;
            if (skipnext) {
                skipnext = false;
                continue;
            }
            Instruction ins = instructionBuffer.get(i);
            if (i + 1 == size) {
                addrightspace = true;
            }
            if (ins instanceof LiteralTextInstruction) {
                text = ((LiteralTextInstruction)ins).getText();
                instructionType = 1;
            } else if (ins instanceof LiteralNonExcapedTextInstruction) {
                text = ((LiteralTextInstruction)ins).getText();
                instructionType = 2;
            } else if (ins instanceof LiteralXMLInstruction) {
                skipnext = true;
                continue;
            }
            if (text != null && text.length() > 0) {
                int firstCharLocation = -1;
                int leftChar = 0;
                int lenght = text.length();
                String leftText = null;
                for (int j = 0; j < lenght; ++j) {
                    char c = text.charAt(j);
                    if (leftChar == 0) {
                        if (c == '\r') {
                            leftChar = 2;
                            if (j + 1 < lenght && text.charAt(j + 1) == '\n') {
                                leftChar = 3;
                            }
                        }
                        if (c == '\n') {
                            leftChar = 1;
                        }
                    }
                    if (Character.isWhitespace(c)) continue;
                    firstCharLocation = j;
                    break;
                }
                if (firstCharLocation == -1) {
                    firstCharLocation = lenght;
                }
                if (firstCharLocation > 0) {
                    switch (leftChar) {
                        case 1: {
                            leftText = "\n";
                            break;
                        }
                        case 2: {
                            leftText = "\r";
                            break;
                        }
                        case 3: {
                            leftText = "\r\n";
                            break;
                        }
                        default: {
                            leftText = lenght > 1 ? text.substring(0, 1) : text;
                            break;
                        }
                    }
                } else {
                    leftText = "";
                }
                if (firstCharLocation == lenght && lenght > 1) {
                    if (addleftspace || addrightspace) {
                        newText = leftText;
                    } else {
                        instructionBuffer.remove(i);
                        --i;
                        --size;
                    }
                } else {
                    int lastCharLocation = TextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                    if (lastCharLocation + 1 < text.length()) {
                        ++lastCharLocation;
                    }
                    newText = firstCharLocation > 0 ? leftText + text.substring(firstCharLocation, lastCharLocation + 1) : text.substring(firstCharLocation, lastCharLocation + 1);
                }
                if (newText != null) {
                    if (instructionType == 1) {
                        instructionBuffer.set(i, new LiteralTextInstruction(newText));
                    } else if (instructionType == 2) {
                        instructionBuffer.set(i, new LiteralNonExcapedTextInstruction(newText));
                    }
                }
            }
            addleftspace = false;
        }
        return size;
    }

    private static int getFirstTextCharLocationIgnoringSpacesTabsAndCarriageReturn(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return i;
        }
        return text.length();
    }

    private static int getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(String text) {
        for (int i = text.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    public String toString() {
        return "TextUnit[" + this.children.size() + "]";
    }

    public void addMessage(FacesMessage.Severity severity, String summary, String detail) {
        this.messages.add(new Object[]{severity, summary, detail});
    }
}

