/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.util.Arrays;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.PhaseEvent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;

public final class ViewHandler
extends TagHandler {
    private static final Class<?>[] LISTENER_SIG = new Class[]{PhaseEvent.class};
    private final TagAttribute locale = this.getAttribute("locale");
    private final TagAttribute renderKitId = this.getAttribute("renderKitId");
    private final TagAttribute contentType = this.getAttribute("contentType");
    private final TagAttribute encoding = this.getAttribute("encoding");
    private final TagAttribute beforePhase = this.getAttribute("beforePhase");
    private final TagAttribute afterPhase = this.getAttribute("afterPhase");
    private final TagAttribute transientAttribute = this.getAttribute("transient");
    private final TagAttribute contracts = this.getAttribute("contracts");
    private final TagAttribute oamEnableViewPool = this.getAttribute("oamEnableViewPool");

    public ViewHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        if (root != null) {
            String[] values;
            String contractsValue;
            MethodExpression m;
            String v;
            if (this.locale != null) {
                root.setLocale(ComponentSupport.getLocale(ctx, this.locale));
            }
            if (this.renderKitId != null) {
                String v2 = this.renderKitId.getValue(ctx);
                root.setRenderKitId(v2);
            }
            String encodingValue = null;
            if (this.contentType != null) {
                int i;
                int j;
                v = this.contentType.getValue(ctx);
                if (v != null && (j = v.indexOf(59)) >= 0 && (i = v.indexOf("charset", j)) >= 0) {
                    i = v.indexOf(61, i) + 1;
                    if (v.length() > i) {
                        encodingValue = v.substring(i);
                    }
                    v = v.substring(0, j);
                }
                ctx.getFacesContext().getAttributes().put("facelets.ContentType", v);
            }
            if (this.encoding != null) {
                v = this.encoding.getValue(ctx);
                ctx.getFacesContext().getAttributes().put("facelets.Encoding", v);
            } else if (encodingValue != null) {
                ctx.getFacesContext().getAttributes().put("facelets.Encoding", encodingValue);
            }
            if (this.beforePhase != null) {
                m = this.beforePhase.getMethodExpression(ctx, null, LISTENER_SIG);
                root.setBeforePhaseListener(m);
            }
            if (this.afterPhase != null) {
                m = this.afterPhase.getMethodExpression(ctx, null, LISTENER_SIG);
                root.setAfterPhaseListener(m);
            }
            if (this.transientAttribute != null) {
                root.setTransient(this.transientAttribute.getBoolean(ctx));
            }
            if (this.contracts != null && (contractsValue = this.contracts.getValue(ctx)) != null && (values = StringUtils.trim(StringUtils.splitShortString(contractsValue, ','))) != null) {
                ctx.getFacesContext().setResourceLibraryContracts(Arrays.asList(values));
            }
            if (this.oamEnableViewPool != null) {
                root.getAttributes().put("oamEnableViewPool", this.oamEnableViewPool.getBoolean(ctx));
            }
        }
        this.nextHandler.apply(ctx, parent);
    }
}

