/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.view.ViewScopeBeanHolder;
import org.apache.myfaces.cdi.view.ViewScopeContextualKey;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;
import org.apache.myfaces.view.ViewScopeProxyMap;

@Typed
public class ViewScopeContext
implements Context {
    private BeanManager beanManager;
    private boolean passivatingScope;

    public ViewScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected ViewScopeBeanHolder getViewScopeBeanHolder() {
        return this.getViewScopeBeanHolder(FacesContext.getCurrentInstance());
    }

    protected ViewScopeBeanHolder getViewScopeBeanHolder(FacesContext facesContext) {
        ViewScopeBeanHolder beanHolder = (ViewScopeBeanHolder)facesContext.getExternalContext().getApplicationMap().get(ViewScopeBeanHolder.class.getName());
        if (beanHolder == null) {
            beanHolder = CDIUtils.get(this.beanManager, ViewScopeBeanHolder.class);
            facesContext.getExternalContext().getApplicationMap().put(ViewScopeBeanHolder.class.getName(), beanHolder);
        }
        return beanHolder;
    }

    public String getCurrentViewScopeId(boolean create) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewScopeProxyMap map = (ViewScopeProxyMap)facesContext.getViewRoot().getViewMap(create);
        if (map != null) {
            String id = map.getViewScopeId();
            if (id == null && create) {
                map.forceCreateWrappedMap(facesContext);
                id = map.getViewScopeId();
            }
            return id;
        }
        return null;
    }

    protected ViewScopeContextualStorage getContextualStorage(boolean createIfNotExist) {
        String viewScopeId = this.getCurrentViewScopeId(createIfNotExist);
        if (createIfNotExist && viewScopeId == null) {
            throw new ContextNotActiveException(this.getClass().getSimpleName() + ": no viewScopeId set for the current view yet!");
        }
        if (viewScopeId != null) {
            return this.getViewScopeBeanHolder().getContextualStorage(this.beanManager, viewScopeId);
        }
        return null;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext.getViewRoot() != null;
        }
        return false;
    }

    public <T> T get(Contextual<T> bean) {
        this.checkActive();
        FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        this.checkActive();
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        ViewScopeContextualStorage storage = this.getContextualStorage(true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public void destroyAllActive() {
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return;
        }
        ViewScopeContext.destroyAllActive(storage);
    }

    public static void destroyAllActive(ViewScopeContextualStorage storage) {
        ViewScopeContext.destroyAllActive(storage, FacesContext.getCurrentInstance());
    }

    public static void destroyAllActive(ViewScopeContextualStorage storage, FacesContext facesContext) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            if (entry.getKey() instanceof ViewScopeContextualKey) continue;
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
        contextMap.clear();
        storage.deactivate();
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

