/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.event.PhaseId;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.ui.DecorateHandler;
import org.apache.myfaces.view.facelets.tag.ui.DefineHandler;
import org.apache.myfaces.view.facelets.tag.ui.LegacyParamHandler;

public final class LegacyDecorateHandler
extends TagHandler
implements TemplateClient {
    private static final Logger log = Logger.getLogger(DecorateHandler.class.getName());
    private final TagAttribute _template = this.getRequiredAttribute("template");
    private final Map<String, DefineHandler> _handlers;
    private final LegacyParamHandler[] _params;

    public LegacyDecorateHandler(TagConfig config) {
        super(config);
        ArrayList<DefineHandler> handlers = TagHandlerUtils.findNextByType(this.nextHandler, DefineHandler.class);
        if (handlers.isEmpty()) {
            this._handlers = null;
        } else {
            this._handlers = new HashMap<String, DefineHandler>(handlers.size());
            for (DefineHandler handler : handlers) {
                this._handlers.put(handler.getName(), handler);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(this.tag + " found Define[" + handler.getName() + ']');
            }
        }
        ArrayList<LegacyParamHandler> params = TagHandlerUtils.findNextByType(this.nextHandler, LegacyParamHandler.class);
        this._params = params.isEmpty() ? null : params.toArray(new LegacyParamHandler[params.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String path;
        VariableMapper orig = ctx.getVariableMapper();
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        actx.pushClient(this);
        if (this._params != null) {
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            ctx.setVariableMapper((VariableMapper)vm);
            for (int i = 0; i < this._params.length; ++i) {
                this._params[i].apply(ctx, parent);
            }
        }
        FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(ctx);
        boolean markInitialState = false;
        if (!this._template.isLiteral()) {
            String uniqueId = actx.generateUniqueFaceletTagId(fcc.startComponentUniqueIdSection(), this.tagId);
            String restoredPath = (String)ComponentSupport.restoreInitialTagState(ctx, fcc, parent, uniqueId);
            if (restoredPath != null) {
                if (!PhaseId.RESTORE_VIEW.equals(ctx.getFacesContext().getCurrentPhaseId())) {
                    path = this._template.getValue(ctx);
                    if (StringUtils.isBlank(path)) {
                        return;
                    }
                    if (!path.equals(restoredPath)) {
                        markInitialState = true;
                    }
                } else {
                    path = restoredPath;
                }
            } else {
                path = this._template.getValue(ctx);
            }
            ComponentSupport.saveInitialTagState(ctx, fcc, parent, uniqueId, path);
        } else {
            path = this._template.getValue(ctx);
        }
        try {
            try {
                boolean oldMarkInitialState = false;
                Boolean isBuildingInitialState = null;
                if (markInitialState) {
                    oldMarkInitialState = fcc.isMarkInitialState();
                    fcc.setMarkInitialState(true);
                    isBuildingInitialState = ctx.getFacesContext().getAttributes().put("javax.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
                }
                try {
                    ctx.includeFacelet(parent, path);
                }
                finally {
                    if (markInitialState) {
                        if (isBuildingInitialState == null) {
                            ctx.getFacesContext().getAttributes().remove("javax.faces.IS_BUILDING_INITIAL_STATE");
                        } else {
                            ctx.getFacesContext().getAttributes().put("javax.faces.IS_BUILDING_INITIAL_STATE", isBuildingInitialState);
                        }
                        fcc.setMarkInitialState(oldMarkInitialState);
                    }
                }
            }
            finally {
                ctx.setVariableMapper(orig);
                actx.popClient(this);
            }
        }
        finally {
            if (!this._template.isLiteral()) {
                fcc.endComponentUniqueIdSection();
                if (fcc.isUsingPSSOnThisView() && fcc.isRefreshTransientBuildOnPSS() && !fcc.isRefreshingTransientBuild()) {
                    ComponentSupport.markComponentToRestoreFully(ctx.getFacesContext(), parent);
                }
                if (fcc.isDynamicComponentSection()) {
                    ComponentSupport.markComponentToRefreshDynamically(ctx.getFacesContext(), parent);
                }
            }
        }
    }

    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            DefineHandler handler;
            DefineHandler defineHandler = handler = this._handlers == null ? null : this._handlers.get(name);
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

