/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.builder;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.flow.Parameter;
import jakarta.faces.flow.builder.MethodCallBuilder;
import java.util.List;
import org.apache.myfaces.flow.FlowImpl;
import org.apache.myfaces.flow.MethodCallNodeImpl;
import org.apache.myfaces.flow.builder.FlowBuilderImpl;

public class MethodCallBuilderImpl
extends MethodCallBuilder {
    private FlowImpl facesFlow;
    private MethodCallNodeImpl methodCallNode;
    private FlowBuilderImpl flowBuilder;

    public MethodCallBuilderImpl(FlowBuilderImpl flowBuilder, FlowImpl facesFlow, String methodCallNodeId) {
        this.flowBuilder = flowBuilder;
        this.facesFlow = facesFlow;
        this.methodCallNode = new MethodCallNodeImpl(methodCallNodeId);
        this.facesFlow.addMethodCall(this.methodCallNode);
    }

    @Override
    public MethodCallBuilder expression(MethodExpression me) {
        this.methodCallNode.setMethodExpression(me);
        return this;
    }

    @Override
    public MethodCallBuilder expression(String methodExpression) {
        this.methodCallNode.setMethodExpression(this.flowBuilder.createMethodExpression(methodExpression));
        return this;
    }

    @Override
    public MethodCallBuilder expression(String methodExpression, Class[] paramTypes) {
        this.methodCallNode.setMethodExpression(this.flowBuilder.createMethodExpression(methodExpression, paramTypes));
        return this;
    }

    @Override
    public MethodCallBuilder parameters(List<Parameter> parameters) {
        for (Parameter p : parameters) {
            this.methodCallNode.addParameter(p);
        }
        return this;
    }

    @Override
    public MethodCallBuilder defaultOutcome(String outcome) {
        this.methodCallNode.setOutcome(this.flowBuilder.createValueExpression(outcome));
        return this;
    }

    @Override
    public MethodCallBuilder defaultOutcome(ValueExpression outcome) {
        this.methodCallNode.setOutcome(outcome);
        return this;
    }

    @Override
    public MethodCallBuilder markAsStartNode() {
        this.facesFlow.setStartNodeId(this.methodCallNode.getId());
        return this;
    }
}

