/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.Conversation;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.RestScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ViewAccessScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.StartConversationEvent;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.RestConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.TimeoutConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ViewAccessConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ViewAccessConversationExpirationEvaluatorRegistry;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationFactory;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationKey;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;

@ApplicationScoped
public class JsfAwareConversationFactory
implements ConversationFactory {
    private static final long serialVersionUID = 2329113439978807663L;
    @Inject
    private BeanManager beanManager;

    public EditableConversation createConversation(ConversationKey conversationKey, ConversationConfig configuration) {
        if (WindowScoped.class.isAssignableFrom(conversationKey.getScope())) {
            DefaultConversation conversation = new DefaultConversation(conversationKey, new WindowConversationExpirationEvaluator(), configuration, this.beanManager);
            return this.processCreatedConversation(conversation, configuration.isStartConversationEventEnabled());
        }
        if (ViewAccessScoped.class.isAssignableFrom(conversationKey.getScope())) {
            DefaultConversation conversation = new DefaultConversation(conversationKey, this.createAndRegisterViewAccessConversationEvaluator(), configuration, this.beanManager);
            return this.processCreatedConversation(conversation, configuration.isStartConversationEventEnabled());
        }
        if (RestScoped.class.isAssignableFrom(conversationKey.getScope())) {
            DefaultConversation conversation = new DefaultConversation(conversationKey, this.createAndRegisterRestConversationEvaluator(), configuration, this.beanManager);
            return this.processCreatedConversation(conversation, configuration.isStartConversationEventEnabled());
        }
        DefaultConversation conversation = new DefaultConversation(conversationKey, new TimeoutConversationExpirationEvaluator(configuration.getConversationTimeoutInMinutes()), configuration, this.beanManager);
        return this.processCreatedConversation(conversation, configuration.isStartConversationEventEnabled());
    }

    private ViewAccessConversationExpirationEvaluator createAndRegisterViewAccessConversationEvaluator() {
        AccessDecisionVoterContext accessDecisionVoterContext = (AccessDecisionVoterContext)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, AccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
        ViewAccessConversationExpirationEvaluator evaluator = new ViewAccessConversationExpirationEvaluator(accessDecisionVoterContext);
        ((ViewAccessConversationExpirationEvaluatorRegistry)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, ViewAccessConversationExpirationEvaluatorRegistry.class, (Annotation[])new Annotation[0])).addViewAccessConversationExpirationEvaluator(evaluator);
        return evaluator;
    }

    private RestConversationExpirationEvaluator createAndRegisterRestConversationEvaluator() {
        AccessDecisionVoterContext accessDecisionVoterContext = (AccessDecisionVoterContext)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, AccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
        RestConversationExpirationEvaluator evaluator = new RestConversationExpirationEvaluator(this.beanManager, accessDecisionVoterContext);
        return evaluator;
    }

    private EditableConversation processCreatedConversation(EditableConversation conversation, boolean startConversationEventEnable) {
        if (startConversationEventEnable) {
            this.beanManager.fireEvent((Object)new StartConversationEvent((Conversation)conversation), new Annotation[0]);
        }
        return conversation;
    }
}

