/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.util.ArrayList;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.InformationProviderBean;
import org.apache.myfaces.extensions.validator.core.storage.ViolationSeverityInterpreterStorage;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverityInterpreter;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
class ExtValContextInternals {
    ExtValContextInternals() {
    }

    boolean isComponentInitializationActivated() {
        return !ExtValCoreConfiguration.get().deactivateComponentInitialization();
    }

    synchronized InformationProviderBean initInformationProviderBean(Map applicationMap) {
        ArrayList<String> informationProviderBeanClassNames = new ArrayList<String>();
        informationProviderBeanClassNames.add(ExtValCoreConfiguration.get().customInformationProviderBeanClassName());
        informationProviderBeanClassNames.add(InformationProviderBean.CUSTOM_BEAN);
        for (String className : informationProviderBeanClassNames) {
            InformationProviderBean informationProviderBean = (InformationProviderBean)ClassUtils.tryToInstantiateClassForName(className);
            if (informationProviderBean == null) continue;
            applicationMap.put(InformationProviderBean.BEAN_NAME, informationProviderBean);
            return informationProviderBean;
        }
        this.tryToInitCustomConfiguredInformationProviderBeanClassName(applicationMap);
        if (applicationMap.containsKey(InformationProviderBean.BEAN_NAME)) {
            return (InformationProviderBean)applicationMap.get(InformationProviderBean.BEAN_NAME);
        }
        return new InformationProviderBean();
    }

    synchronized void tryToInitCustomConfiguredInformationProviderBeanClassName(Map applicationMap) {
        InformationProviderBean bean = (InformationProviderBean)ExtValUtils.getELHelper().getBean(InformationProviderBean.CUSTOM_BEAN.replace(".", "_"));
        if (bean != null) {
            applicationMap.put(InformationProviderBean.BEAN_NAME, bean);
        }
    }

    InformationProviderBean getInformationProviderBean() {
        Map applicationMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        InformationProviderBean bean = (InformationProviderBean)applicationMap.get(InformationProviderBean.BEAN_NAME);
        if (bean == null) {
            return this.initInformationProviderBean(applicationMap);
        }
        return bean;
    }

    ViolationSeverityInterpreter getRequestScopedViolationSeverityInterpreter() {
        return ExtValUtils.getStorage(ViolationSeverityInterpreterStorage.class, ViolationSeverityInterpreterStorage.class.getName()).getViolationSeverityInterpreter();
    }
}

