/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.metadata.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.myfaces.extensions.validator.core.Nested;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.mapper.SubMapperAwareNameMapper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class SortedNameMapperList<T extends NameMapper>
extends CopyOnWriteArrayList<T> {
    private static final long serialVersionUID = 1502156999599962365L;
    private List<T> wrapped;
    private List<T> globalSubNameMapperList;

    SortedNameMapperList(List<T> wrapped, List<T> subNameMapperList) {
        this.wrapped = wrapped;
        this.globalSubNameMapperList = subNameMapperList;
    }

    @Override
    public boolean add(T t) {
        if (t != null && t.getClass().isAnnotationPresent(Nested.class)) {
            return this.addSubNameMapper(t);
        }
        boolean result = this.wrapped.add(t);
        this.sortWrappedList();
        return result;
    }

    private void sortWrappedList() {
        ArrayList<T> sortableList = new ArrayList<T>(this.wrapped);
        Collections.sort(sortableList, new Comparator<T>(){

            @Override
            public int compare(T nm1, T nm2) {
                if (nm1 instanceof SubMapperAwareNameMapper && nm2 instanceof SubMapperAwareNameMapper) {
                    return 0;
                }
                return nm1 instanceof SubMapperAwareNameMapper ? 1 : -1;
            }
        });
        this.wrapped.clear();
        this.wrapped.addAll(sortableList);
    }

    private boolean addSubNameMapper(T subNameMapper) {
        boolean result = false;
        for (NameMapper nameMapper : this.wrapped) {
            if (!(nameMapper instanceof SubMapperAwareNameMapper)) continue;
            ((SubMapperAwareNameMapper)nameMapper).addNameMapper(subNameMapper);
            result = true;
        }
        this.tryToAddMapperAsGlobalSubNameMapper(subNameMapper);
        return result;
    }

    private void tryToAddMapperAsGlobalSubNameMapper(T subNameMapper) {
        if (!this.globalSubNameMapperList.contains(subNameMapper)) {
            this.globalSubNameMapperList.add(subNameMapper);
        }
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.wrapped.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.wrapped.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public T get(int index) {
        return (T)((NameMapper)this.wrapped.get(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((NameMapper)this.wrapped.set(index, element));
    }

    @Override
    public void add(int index, T element) {
        this.wrapped.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((NameMapper)this.wrapped.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.wrapped.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrapped.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.wrapped.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.wrapped.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.wrapped.subList(fromIndex, toIndex);
    }
}

