/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.initializer.component;

import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.trinidad.ExtValTrinidadClientValidatorWrapper;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.TrinidadComponentInitializer;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;
import org.apache.myfaces.trinidad.validator.ClientValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ToDo(value=Priority.MEDIUM, description="skipValidationSupport for client-side validation")
@UsageInformation(value={UsageCategory.INTERNAL})
class LengthInitializer
extends TrinidadComponentInitializer {
    LengthInitializer() {
    }

    @Override
    public boolean configureTrinidadComponent(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        boolean informationAdded = false;
        LengthValidator lengthValidator = (LengthValidator)facesContext.getApplication().createValidator("org.apache.myfaces.trinidad.Length");
        Object minLength = null;
        if (metaData.containsKey("min_length")) {
            minLength = metaData.get("min_length");
        } else if (metaData.containsKey("min_length_default")) {
            minLength = metaData.get("min_length_default");
        }
        if (minLength instanceof Integer) {
            lengthValidator.setMinimum(((Integer)minLength).intValue());
            informationAdded = true;
        }
        Object maxLength = null;
        if (metaData.containsKey("max_length")) {
            maxLength = metaData.get("max_length");
        } else if (metaData.containsKey("max_length_default")) {
            maxLength = metaData.get("max_length_default");
        }
        if (maxLength instanceof Integer) {
            if (this.processComponent(uiComponent)) {
                ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"setMaximumLength", (Class[])new Class[]{Integer.TYPE}), (Object[])new Object[]{maxLength});
            }
            lengthValidator.setMaximum(((Integer)maxLength).intValue());
            informationAdded = true;
        }
        if (informationAdded && lengthValidator instanceof ClientValidator) {
            if (uiComponent instanceof EditableValueHolder) {
                ((EditableValueHolder)uiComponent).addValidator((Validator)new ExtValTrinidadClientValidatorWrapper((ClientValidator)lengthValidator));
            } else if (uiComponent instanceof CoreOutputLabel) {
                if (lengthValidator.getMinimum() > 0) {
                    ((CoreOutputLabel)uiComponent).setShowRequired(true);
                }
                if (Boolean.TRUE.equals(metaData.get("skip_validation"))) {
                    ((CoreOutputLabel)uiComponent).setShowRequired(false);
                }
            }
            return true;
        }
        return false;
    }
}

