/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.GroupSequence;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.annotation.BeanValidation;
import org.apache.myfaces.extensions.validator.beanval.annotation.extractor.DefaultGroupControllerScanningExtractor;
import org.apache.myfaces.extensions.validator.beanval.payload.ViolationSeverity;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationEntry;
import org.apache.myfaces.extensions.validator.beanval.util.LabeledMessageInternals;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.validation.message.FacesMessageHolder;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class ExtValBeanValidationMetaDataInternals {
    private Logger logger;
    private LabeledMessageInternals labeledMessageInternals = new LabeledMessageInternals();
    private ELHelper elHelper;

    ExtValBeanValidationMetaDataInternals(Logger logger, ELHelper elHelper) {
        this.logger = logger;
        this.elHelper = elHelper;
    }

    void extractExtValBeanValidationMetaData(PropertyDetails propertyDetails, boolean processMetaDataForValidation, String[] key, Object firstBean, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId) {
        this.inspectFirstBean(processMetaDataForValidation, firstBean, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId);
        this.inspectFirstProperty(processMetaDataForValidation, key, firstBean, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, key.length == 2);
        this.inspectBaseOfProperty(propertyDetails, processMetaDataForValidation, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId);
        this.inspectLastProperty(propertyDetails, processMetaDataForValidation, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId);
    }

    void processExtValBeanValidationMetaData(UIComponent component, PropertyDetails propertyDetails, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId) {
        ExtValBeanValidationContext extValBeanValidationContext = ExtValBeanValidationContext.getCurrentInstance();
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        this.processFoundGroups(extValBeanValidationContext, activeViewId, clientId, foundGroupsForPropertyValidation);
        this.processRestrictedGroups(extValBeanValidationContext, activeViewId, clientId, restrictedGroupsForPropertyValidation);
        this.initModelValidation(extValBeanValidationContext, component, propertyDetails, modelValidationEntryList, restrictedGroupsForModelValidation);
    }

    private void inspectFirstBean(boolean processMetaDataForValidation, Object firstBean, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId) {
        this.processClass(firstBean, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
    }

    private void inspectFirstProperty(boolean processMetaDataForValidation, String[] key, Object firstBean, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean isLastProperty) {
        this.processFieldsAndProperties(key[0] + "." + key[1], firstBean, key[1], foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation, isLastProperty);
    }

    private void inspectBaseOfProperty(PropertyDetails propertyDetails, boolean processMetaDataForValidation, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId) {
        this.processClass(propertyDetails.getBaseObject(), foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
    }

    private void inspectLastProperty(PropertyDetails propertyDetails, boolean processMetaDataForValidation, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId) {
        this.processFieldsAndProperties(propertyDetails.getKey(), propertyDetails.getBaseObject(), propertyDetails.getProperty(), foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation, true);
    }

    private void processClass(Object objectToInspect, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean processMetaDataForValidation) {
        Class classToInspect = ProxyUtils.getUnproxiedClass(objectToInspect.getClass());
        while (!Object.class.getName().equals(classToInspect.getName())) {
            this.transferGroupValidationInformationToFoundGroups(classToInspect, objectToInspect, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
            this.processInterfaces(classToInspect, objectToInspect, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
            classToInspect = classToInspect.getSuperclass();
        }
    }

    private void processFieldsAndProperties(String key, Object base, String property, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean processMetaDataForValidation, boolean isLastProperty) {
        PropertyInformation propertyInformation = new DefaultGroupControllerScanningExtractor().extract(FacesContext.getCurrentInstance(), new PropertyDetails(key, base, property));
        for (MetaDataEntry metaDataEntry : propertyInformation.getMetaDataEntries()) {
            if (metaDataEntry.getValue() instanceof BeanValidation) {
                this.tryToProcessMetaData((BeanValidation)metaDataEntry.getValue(), this.tryToCreateNewTarget(base, property, isLastProperty), foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
                continue;
            }
            if (!(metaDataEntry.getValue() instanceof BeanValidation.List)) continue;
            for (BeanValidation currentBeanValidation : ((BeanValidation.List)metaDataEntry.getValue()).value()) {
                this.tryToProcessMetaData(currentBeanValidation, this.tryToCreateNewTarget(base, property, isLastProperty), foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
            }
        }
    }

    private Object tryToCreateNewTarget(Object base, String property, boolean isLastProperty) {
        if (isLastProperty) {
            return base;
        }
        Object result = this.getValueOfProperty(base, property);
        if (result == null) {
            return base;
        }
        return result;
    }

    private Object getValueOfProperty(Object base, String property) {
        property = property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
        Class targetClass = ProxyUtils.getUnproxiedClass(base.getClass());
        Method targetMethod = ReflectionUtils.tryToGetMethod((Class)targetClass, (String)("get" + property));
        if (targetMethod == null) {
            targetMethod = ReflectionUtils.tryToGetMethod((Class)targetClass, (String)("is" + property));
        }
        if (targetMethod == null) {
            throw new IllegalStateException("class " + targetClass + " has no public get/is " + property.toLowerCase());
        }
        return ReflectionUtils.tryToInvokeMethod((Object)base, (Method)targetMethod);
    }

    private void processFoundGroups(ExtValBeanValidationContext extValBeanValidationContext, String currentViewId, String clientId, List<Class> foundGroupsForPropertyValidation) {
        for (Class currentGroupClass : foundGroupsForPropertyValidation) {
            extValBeanValidationContext.addGroup(currentGroupClass, currentViewId, clientId);
        }
    }

    private void processRestrictedGroups(ExtValBeanValidationContext extValBeanValidationContext, String currentViewId, String clientId, List<Class> restrictedGroupsForPropertyValidation) {
        for (Class currentGroupClass : restrictedGroupsForPropertyValidation) {
            extValBeanValidationContext.restrictGroup(currentGroupClass, currentViewId, clientId);
        }
    }

    private void initModelValidation(ExtValBeanValidationContext extValBeanValidationContext, UIComponent component, PropertyDetails propertyDetails, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation) {
        for (ModelValidationEntry modelValidationEntry : modelValidationEntryList) {
            for (Class restrictedGroup : restrictedGroupsForModelValidation) {
                modelValidationEntry.removeGroup(restrictedGroup);
            }
            if (modelValidationEntry.getGroups().length <= 0) continue;
            if (modelValidationEntry.getValidationTargets().isEmpty()) {
                modelValidationEntry.addValidationTarget(propertyDetails.getBaseObject());
            }
            modelValidationEntry.setComponent(component);
            extValBeanValidationContext.addModelValidationEntry(modelValidationEntry);
        }
    }

    @ToDo(value=Priority.MEDIUM, description="test proxy support")
    private void transferGroupValidationInformationToFoundGroups(Class<?> classToInspect, Object objectToInspect, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean processMetaDataForValidation) {
        if (classToInspect.isAnnotationPresent(BeanValidation.class)) {
            this.tryToProcessMetaData(classToInspect.getAnnotation(BeanValidation.class), objectToInspect, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
        } else if (classToInspect.isAnnotationPresent(BeanValidation.List.class)) {
            for (BeanValidation currentBeanValidation : classToInspect.getAnnotation(BeanValidation.List.class).value()) {
                this.tryToProcessMetaData(currentBeanValidation, objectToInspect, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
            }
        }
    }

    private void processInterfaces(Class currentClass, Object metaDataSourceObject, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean processMetaDataForValidation) {
        for (Class<?> currentInterface : currentClass.getInterfaces()) {
            this.transferGroupValidationInformationToFoundGroups(currentClass, metaDataSourceObject, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
            this.processInterfaces(currentInterface, metaDataSourceObject, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId, processMetaDataForValidation);
        }
    }

    private void tryToProcessMetaData(BeanValidation beanValidation, Object metaDataSourceObject, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, String activeViewId, boolean processMetaDataForValidation) {
        for (String currentViewId : beanValidation.viewIds()) {
            if (!this.useMetaDataForViewId(beanValidation, currentViewId, activeViewId)) continue;
            this.processMetaData(beanValidation, metaDataSourceObject, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, processMetaDataForValidation);
            break;
        }
    }

    private boolean useMetaDataForViewId(BeanValidation beanValidation, String viewId, String activeViewId) {
        return (viewId.equals(activeViewId) || viewId.equals("*")) && this.isValidationPermitted(beanValidation);
    }

    private void processMetaData(BeanValidation beanValidation, Object metaDataSourceObject, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, boolean processMetaDataForValidation) {
        if (processMetaDataForValidation && this.isModelValidation(beanValidation)) {
            this.addModelValidationEntry(beanValidation, metaDataSourceObject, modelValidationEntryList, restrictedGroupsForModelValidation, processMetaDataForValidation);
        } else if (!this.isModelValidation(beanValidation)) {
            this.processGroups(beanValidation, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, processMetaDataForValidation);
        }
    }

    private boolean isValidationPermitted(BeanValidation beanValidation) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        for (String condition : beanValidation.conditions()) {
            if (this.elHelper.isELTermWellFormed((Object)condition) && this.elHelper.isELTermValid(facesContext, condition)) {
                if (!Boolean.TRUE.equals(this.elHelper.getValueOfExpression(facesContext, new ValueBindingExpression(condition)))) continue;
                return true;
            }
            this.logger.severe("an invalid condition is used: " + condition);
        }
        return false;
    }

    private boolean isModelValidation(BeanValidation beanValidation) {
        return beanValidation.modelValidation().isActive();
    }

    private void addModelValidationEntry(BeanValidation beanValidation, Object metaDataSourceObject, List<ModelValidationEntry> modelValidationEntryList, List<Class> restrictedGroupsForModelValidation, boolean processMetaDataForValidation) {
        ModelValidationEntry modelValidationEntry = new ModelValidationEntry();
        List<Class> groupClassList = this.createGroupClassList(beanValidation, processMetaDataForValidation);
        modelValidationEntry.setGroups(groupClassList);
        modelValidationEntry.setDisplayMessageInline(beanValidation.modelValidation().displayInline());
        modelValidationEntry.setCustomMessage(beanValidation.modelValidation().message());
        modelValidationEntry.setMetaDataSourceObject(metaDataSourceObject);
        for (String validationTargetExpression : beanValidation.modelValidation().validationTargets()) {
            Object validationTarget;
            if ("".equals(validationTargetExpression) || (validationTarget = this.tryToResolveValidationTargetExpression(validationTargetExpression)) == null) continue;
            modelValidationEntry.addValidationTarget(validationTarget);
        }
        if (beanValidation.restrictGroups().length > 0) {
            restrictedGroupsForModelValidation.addAll(Arrays.asList(beanValidation.restrictGroups()));
        }
        if (modelValidationEntry.getValidationTargets().isEmpty()) {
            modelValidationEntry.addValidationTarget(metaDataSourceObject);
        }
        modelValidationEntryList.add(modelValidationEntry);
    }

    private Object tryToResolveValidationTargetExpression(String validationTargetExpression) {
        ValueBindingExpression valueBindingExpression = new ValueBindingExpression(validationTargetExpression);
        return this.elHelper.getValueOfExpression(FacesContext.getCurrentInstance(), valueBindingExpression);
    }

    private void processGroups(BeanValidation beanValidation, List<Class> foundGroupsForPropertyValidation, List<Class> restrictedGroupsForPropertyValidation, boolean processMetaDataForValidation) {
        List<Class> groupClassList = this.createGroupClassList(beanValidation, processMetaDataForValidation);
        foundGroupsForPropertyValidation.addAll(groupClassList);
        if (beanValidation.restrictGroups().length > 0) {
            restrictedGroupsForPropertyValidation.addAll(Arrays.asList(beanValidation.restrictGroups()));
        }
    }

    String createLabeledMessage(String violationMessage, boolean isDetailMessage) {
        return this.labeledMessageInternals.createLabeledMessage(violationMessage, isDetailMessage);
    }

    FacesMessage.Severity calcSeverity(ConstraintViolation<Object> violation) {
        for (Class payload : violation.getConstraintDescriptor().getPayload()) {
            if (ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Warn.class).isAssignableFrom(payload)) {
                return FacesMessage.SEVERITY_WARN;
            }
            if (ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Info.class).isAssignableFrom(payload)) {
                return FacesMessage.SEVERITY_INFO;
            }
            if (!ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Fatal.class).isAssignableFrom(payload)) continue;
            return FacesMessage.SEVERITY_FATAL;
        }
        return FacesMessage.SEVERITY_ERROR;
    }

    void processFacesMessage(FacesContext facesContext, UIComponent uiComponent, List<FacesMessageHolder> facesMessageHolderList, FacesMessage facesMessage) {
        FacesMessageHolder facesMessageHolder = new FacesMessageHolder(facesMessage);
        facesMessageHolder.setClientId(uiComponent.getClientId(facesContext));
        facesMessageHolderList.add(facesMessageHolder);
    }

    boolean executeAfterThrowingInterceptors(UIComponent uiComponent, Object convertedObject, ValidatorException validatorException) {
        return ExtValUtils.executeAfterThrowingInterceptors((UIComponent)uiComponent, null, (Object)convertedObject, (ValidatorException)validatorException, null);
    }

    boolean isMessageTextUnchanged(ValidatorException validatorException, String violationSummaryMessage, String violationDetailMessage) {
        return violationSummaryMessage.equals(validatorException.getFacesMessage().getSummary()) && violationDetailMessage.equals(validatorException.getFacesMessage().getDetail());
    }

    ValidatorException createValidatorException(String violationSummaryMessage, String violationDetailMessage, FacesMessage.Severity severity) {
        return new ValidatorException(ExtValUtils.createFacesMessage((FacesMessage.Severity)severity, (String)violationSummaryMessage, (String)violationDetailMessage));
    }

    List<FacesMessageHolder> getFacesMessageListWithLowSeverity(List<FacesMessageHolder> violationMessages) {
        ArrayList<FacesMessageHolder> result = new ArrayList<FacesMessageHolder>();
        for (FacesMessageHolder facesMessageHolder : violationMessages) {
            if (!FacesMessage.SEVERITY_WARN.equals(facesMessageHolder.getFacesMessage().getSeverity()) && !FacesMessage.SEVERITY_INFO.equals(facesMessageHolder.getFacesMessage().getSeverity())) continue;
            result.add(facesMessageHolder);
        }
        return result;
    }

    List<FacesMessageHolder> getFacesMessageListWithHighSeverity(List<FacesMessageHolder> violationMessageHolderList) {
        ArrayList<FacesMessageHolder> result = new ArrayList<FacesMessageHolder>();
        for (FacesMessageHolder facesMessageHolder : violationMessageHolderList) {
            if (!FacesMessage.SEVERITY_ERROR.equals(facesMessageHolder.getFacesMessage().getSeverity()) && !FacesMessage.SEVERITY_FATAL.equals(facesMessageHolder.getFacesMessage().getSeverity())) continue;
            result.add(facesMessageHolder);
        }
        return result;
    }

    void addMessages(List<FacesMessageHolder> facesMessageHolderListWithLowSeverity) {
        for (FacesMessageHolder facesMessageHolder : facesMessageHolderListWithLowSeverity) {
            ExtValUtils.tryToAddViolationMessageForComponentId((String)facesMessageHolder.getClientId(), (FacesMessage)facesMessageHolder.getFacesMessage());
        }
    }

    private List<Class> createGroupClassList(BeanValidation beanValidation, boolean processMetaDataForValidation) {
        if (processMetaDataForValidation) {
            return Arrays.asList(beanValidation.useGroups());
        }
        ArrayList<Class> groupClassList = new ArrayList<Class>();
        for (Class groupClass : beanValidation.useGroups()) {
            GroupSequence groupSequence = groupClass.getAnnotation(GroupSequence.class);
            if (groupSequence != null) {
                groupClassList.addAll(Arrays.asList(groupSequence.value()));
                continue;
            }
            groupClassList.add(groupClass);
        }
        return groupClassList;
    }
}

