/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.requestParameterProvider;

import junit.framework.TestCase;
import org.apache.myfaces.orchestra.frameworkAdapter.local.LocalFrameworkAdapter;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.conversation.basic.LogConversationMessager;

public class TestRequestParameterProviderManager extends TestCase
{
    public void testParameterAdding()
    {
        LocalFrameworkAdapter lfa = new LocalFrameworkAdapter();
        lfa.setConversationMessager(new LogConversationMessager());
        lfa.setRequestAttribute(RequestParameterServletFilter.REQUEST_PARAM_FILTER_CALLED, Boolean.TRUE);
        FrameworkAdapter.setCurrentInstance(lfa);
        RequestParameterProviderManager man = RequestParameterProviderManager.getInstance();
        man.register(new RequestParameterProvider()
        {

            public String[] getFields()
            {
                return new String[] {"FIELD"};
            }

            public String getFieldValue(String field)
            {
                return "VALUE";
            }
        });

        assertEquals("http://domain/path?FIELD=VALUE", man.encodeAndAttachParameters("http://domain/path"));
        assertEquals("http://domain/path?ab=cd&FIELD=VALUE", man.encodeAndAttachParameters("http://domain/path?ab=cd"));
        assertEquals("http://domain/path?FIELD=VALUE#", man.encodeAndAttachParameters("http://domain/path#"));
        assertEquals("http://domain/path?FIELD=VALUE#22", man.encodeAndAttachParameters("http://domain/path#22"));
        assertEquals("http://domain/path?ab=cd&FIELD=VALUE#22", man.encodeAndAttachParameters("http://domain/path?ab=cd#22"));
        assertEquals("javascript:anyMethod(anyUrl)", man.encodeAndAttachParameters("javascript:anyMethod(anyUrl)"));
        assertEquals("relative/url?FIELD=VALUE", man.encodeAndAttachParameters("relative/url"));
        assertEquals("useless:/url?FIELD=VALUE", man.encodeAndAttachParameters("useless:/url"));
        assertEquals("#", man.encodeAndAttachParameters("#"));
    }
}
