/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISelectOneRadio;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOne select = (UISelectOne)component;
        super.prepareRender(facesContext, (UIComponent)select);
        if (select instanceof UISelectOneRadio && ((UISelectOneRadio)select).isInline()) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)((UISelectOneRadio)select), (Markup)Markup.INLINE);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOneRadio select = (UISelectOneRadio)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String id = select.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        boolean required = select.isRequired();
        style.setDisplay(null);
        writer.startElement("ol", (UIComponent)select);
        writer.writeIdAttribute(id);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        boolean first = true;
        Object value = select.getValue();
        String submittedValue = (String)select.getSubmittedValue();
        int i = 0;
        for (SelectItem item : items) {
            String label;
            org.apache.myfaces.tobago.model.SelectItem tobagoItem;
            String image;
            Integer tabIndex;
            String itemId = id + "::" + i++;
            writer.startElement("li", (UIComponent)select);
            writer.startElement("input", (UIComponent)select);
            writer.writeAttribute("type", "radio", false);
            String formattedValue = RenderUtils.getFormattedValue(facesContext, (UIComponent)select, item.getValue());
            boolean checked = submittedValue == null ? ObjectUtils.equals((Object)item.getValue(), (Object)value) : ObjectUtils.equals((Object)formattedValue, (Object)submittedValue);
            writer.writeAttribute("checked", checked);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            writer.writeAttribute("value", formattedValue, true);
            writer.writeAttribute("disabled", item.isDisabled() || disabled);
            writer.writeAttribute("readonly", readonly);
            writer.writeAttribute("required", required);
            if (first) {
                HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
                first = false;
            }
            if ((tabIndex = select.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            HtmlRendererUtils.renderCommandFacet((UIComponent)select, itemId, facesContext, writer);
            writer.endElement("input");
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = (tobagoItem = (org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                String imageToRender = ResourceManagerUtils.getImageOrDisabledImageWithPath((FacesContext)facesContext, (String)image, (boolean)item.isDisabled());
                writer.startElement("img", (UIComponent)select);
                writer.writeAttribute("src", imageToRender, true);
                writer.writeAttribute("alt", "", false);
                writer.endElement("img");
            }
            if ((label = item.getLabel()) != null) {
                writer.startElement("label", (UIComponent)select);
                writer.writeAttribute("for", itemId, false);
                writer.writeText(label);
                writer.endElement("label");
            }
            writer.endElement("li");
        }
        writer.endElement("ol");
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        UISelectOneRadio select = (UISelectOneRadio)component;
        Measure heightOfOne = super.getHeight(facesContext, component);
        if (select.isInline()) {
            return heightOfOne;
        }
        int count = 0;
        for (SelectItem ignored : SelectItemUtils.getItemIterator(facesContext, (UIComponent)((UISelectOne)component))) {
            ++count;
        }
        return heightOfOne.multiply(count);
    }
}

