/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.component.AbstractUIMeta;
import org.apache.myfaces.tobago.internal.component.AbstractUIMetaLink;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIScript;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.CookieUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PageRenderer.class);
    private static final String LAST_FOCUS_ID = "lastFocusId";
    private static final String HEAD_TARGET = "head";
    private static final String BODY_TARGET = "body";

    public void decode(FacesContext facesContext, UIComponent component) {
        AbstractUIPage page = (AbstractUIPage)component;
        String clientId = page.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String lastFocusId = (String)externalContext.getRequestParameterMap().get(clientId + "::" + LAST_FOCUS_ID);
        if (lastFocusId != null) {
            TobagoContext.getInstance(facesContext).setFocusId(lastFocusId);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String partialAction;
        boolean portlet;
        AbstractUIPage page = (AbstractUIPage)component;
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        TobagoContext tobagoContext = TobagoContext.getInstance(facesContext);
        if (tobagoContext.getFocusId() == null && !StringUtils.isBlank(page.getFocusId())) {
            tobagoContext.setFocusId(page.getFocusId());
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        facesContext.setResponseWriter((ResponseWriter)writer);
        if (tobagoConfig.isPreventFrameAttacks()) {
            ResponseUtils.ensureXFrameOptionsHeader(facesContext);
        }
        ResponseUtils.ensureNoCacheHeader(facesContext);
        ResponseUtils.ensureContentSecurityPolicyHeader(facesContext, tobagoConfig.getContentSecurityPolicy());
        if (LOG.isDebugEnabled()) {
            Iterator iterator = page.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                LOG.debug("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'");
            }
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        Object request = externalContext.getRequest();
        Object response = externalContext.getResponse();
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String viewId = viewRoot.getViewId();
        String formAction = externalContext.encodeActionURL(viewHandler.getActionURL(facesContext, viewId));
        boolean bl = portlet = PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse;
        if (portlet) {
            MimeResponse mimeResponse = (MimeResponse)response;
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            partialAction = externalContext.encodeResourceURL(resourceURL.toString());
        } else {
            partialAction = null;
        }
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader(facesContext, contentType);
        if (tobagoConfig.isSetNosniffHeader()) {
            ResponseUtils.ensureNosniffHeader(facesContext);
        }
        Theme theme = tobagoContext.getTheme();
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest) {
            CookieUtils.setThemeNameToCookie((HttpServletRequest)request, (HttpServletResponse)response, theme.getName());
        }
        String clientId = page.getClientId(facesContext);
        boolean productionMode = facesContext.isProjectStage(ProjectStage.Production);
        Markup markup = page.getMarkup();
        TobagoClass spread = markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null;
        String title = page.getLabel();
        if (!portlet) {
            Object language;
            writer.startElement(HtmlElements.HTML);
            Locale locale = viewRoot.getLocale();
            if (locale != null && (language = locale.getLanguage()) != null) {
                writer.writeAttribute(HtmlAttributes.LANG, (String)language, false);
            }
        }
        writer.writeClassAttribute(spread);
        writer.startElement(HtmlElements.HEAD);
        HeadResources headResources = new HeadResources(facesContext, viewRoot.getComponentResources(facesContext, HEAD_TARGET), writer.getCharacterEncoding());
        for (UIComponent uIComponent : headResources.getMetas()) {
            uIComponent.encodeAll(facesContext);
        }
        writer.startElement(HtmlElements.TITLE);
        writer.writeText(title != null ? title : "");
        writer.endElement(HtmlElements.TITLE);
        AbstractUIStyle style = null;
        for (String styleFile : theme.getStyleResources(productionMode)) {
            if (style == null) {
                style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
                style.setTransient(true);
            }
            style.setFile(contextPath + styleFile);
            style.encodeAll(facesContext);
        }
        for (UIComponent styles : headResources.getStyles()) {
            styles.encodeAll(facesContext);
        }
        String string = page.getApplicationIcon();
        if (string != null) {
            writer.startElement(HtmlElements.LINK);
            if (string.endsWith(".ico")) {
                writer.writeAttribute(HtmlAttributes.REL, "shortcut icon", false);
                writer.writeAttribute(HtmlAttributes.HREF, string, true);
            } else {
                writer.writeAttribute(HtmlAttributes.REL, "icon", false);
                writer.writeAttribute(HtmlAttributes.TYPE, MimeTypeUtils.getMimeTypeForFile(string), true);
                writer.writeAttribute(HtmlAttributes.HREF, string, true);
            }
            writer.endElement(HtmlElements.LINK);
        }
        AbstractUIScript script = null;
        for (String scriptFile : theme.getScriptResources(productionMode)) {
            if (script == null) {
                script = (AbstractUIScript)facesContext.getApplication().createComponent(facesContext, Tags.script.componentType(), RendererTypes.Script.name());
                script.setTransient(true);
            }
            script.setFile(contextPath + scriptFile);
            script.encodeAll(facesContext);
        }
        for (UIComponent scripts : headResources.getScripts()) {
            scripts.encodeAll(facesContext);
        }
        for (UIComponent misc : headResources.getMisc()) {
            misc.encodeAll(facesContext);
        }
        writer.endElement(HtmlElements.HEAD);
        if (!portlet) {
            writer.startElement(HtmlElements.BODY);
            writer.writeClassAttribute(spread);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute((CssItem)TobagoClass.PAGE, TobagoClass.PAGE.createMarkup(portlet ? Markup.PORTLET.add(page.getMarkup()) : page.getMarkup()), new CssItem[]{BootstrapClass.CONTAINER_FLUID, spread, page.getCustomClass()});
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)page);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, page)));
        writer.startElement(HtmlElements.FORM);
        writer.writeClassAttribute(spread);
        writer.writeAttribute(HtmlAttributes.ACTION, formAction, true);
        if (partialAction != null) {
            writer.writeAttribute(DataAttributes.PARTIAL_ACTION, partialAction, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("partial action = " + partialAction);
        }
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute(HtmlAttributes.METHOD, this.getMethod(page), false);
        String enctype = tobagoContext.getEnctype();
        if (enctype != null) {
            writer.writeAttribute(HtmlAttributes.ENCTYPE, enctype, false);
        }
        writer.writeAttribute(HtmlAttributes.ACCEPT_CHARSET, AbstractUIPage.FORM_ACCEPT_CHARSET.name(), false);
        writer.writeAttribute(DataAttributes.CONTEXT_PATH, contextPath, true);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute("javax.faces.source");
        writer.writeIdAttribute("javax.faces.source");
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(clientId + "::" + LAST_FOCUS_ID);
        writer.writeIdAttribute(clientId + "::" + LAST_FOCUS_ID);
        writer.writeAttribute(HtmlAttributes.VALUE, tobagoContext.getFocusId(), true);
        writer.endElement(HtmlElements.INPUT);
        if (TobagoConfig.getInstance(FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            Secret.encode(facesContext, writer);
        }
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            hidden.encodeAll(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIPage page = (AbstractUIPage)component;
        UIViewRoot viewRoot = facesContext.getViewRoot();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = page.getClientId(facesContext);
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        Object response = facesContext.getExternalContext().getResponse();
        boolean portlet = PortletUtils.isPortletApiAvailable() && response instanceof MimeResponse;
        boolean ajax = facesContext.getPartialViewContext().isAjaxRequest();
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__MENU_STORE);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(clientId + "::" + "jsf-state-container");
        writer.flush();
        if (!ajax) {
            viewHandler.writeState(facesContext);
        }
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.FORM);
        writer.startElement(HtmlElements.NOSCRIPT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__NOSCRIPT);
        writer.writeText(TobagoResourceBundle.getString(facesContext, "pageNoscript"));
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.NOSCRIPT);
        writer.endElement(HtmlElements.DIV);
        List bodyResources = viewRoot.getComponentResources(facesContext, BODY_TARGET);
        for (UIComponent bodyResource : bodyResources) {
            bodyResource.encodeAll(facesContext);
        }
        if (!portlet) {
            writer.endElement(HtmlElements.BODY);
            writer.endElement(HtmlElements.HTML);
        }
        AccessKeyLogger.logStatus(facesContext);
    }

    private String getMethod(AbstractUIPage page) {
        return ComponentUtils.getStringAttribute((UIComponent)page, Attributes.method, "post");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private static class HeadResources {
        private List<UIComponent> metas = new ArrayList<UIComponent>();
        private List<UIComponent> styles = new ArrayList<UIComponent>();
        private List<UIComponent> scripts = new ArrayList<UIComponent>();
        private List<UIComponent> misc = new ArrayList<UIComponent>();

        HeadResources(FacesContext facesContext, Collection<? extends UIComponent> collection, String charset) {
            for (UIComponent uIComponent : collection) {
                Map attributes;
                if (uIComponent instanceof AbstractUIMeta || uIComponent instanceof AbstractUIMetaLink) {
                    this.metas.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof AbstractUIStyle) {
                    this.styles.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof AbstractUIScript) {
                    this.scripts.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof UIOutput && "javax.faces".equals((attributes = uIComponent.getAttributes()).get("library")) && "jsf.js".equals(attributes.get("name"))) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skip rendering resource jsf.js");
                    continue;
                }
                this.misc.add(uIComponent);
            }
            if (!this.containsNameViewport(this.metas)) {
                AbstractUIMeta viewportMeta = (AbstractUIMeta)facesContext.getApplication().createComponent(facesContext, Tags.meta.componentType(), RendererTypes.Meta.name());
                viewportMeta.setName("viewport");
                viewportMeta.setContent("width=device-width, initial-scale=1.0");
                viewportMeta.setTransient(true);
                this.metas.add(0, (UIComponent)viewportMeta);
            }
            if (!this.containsCharset(this.metas)) {
                AbstractUIMeta charsetMeta = (AbstractUIMeta)facesContext.getApplication().createComponent(facesContext, Tags.meta.componentType(), RendererTypes.Meta.name());
                charsetMeta.setCharset(charset);
                charsetMeta.setTransient(true);
                this.metas.add(0, (UIComponent)charsetMeta);
            }
        }

        public List<UIComponent> getMetas() {
            return this.metas;
        }

        public List<UIComponent> getStyles() {
            return this.styles;
        }

        public List<UIComponent> getScripts() {
            return this.scripts;
        }

        public List<UIComponent> getMisc() {
            return this.misc;
        }

        private boolean containsCharset(List<UIComponent> headComponents) {
            for (UIComponent headComponent : headComponents) {
                if (!(headComponent instanceof AbstractUIMeta) || ((AbstractUIMeta)headComponent).getCharset() == null) continue;
                return true;
            }
            return false;
        }

        private boolean containsNameViewport(List<UIComponent> headComponents) {
            for (UIComponent headComponent : headComponents) {
                if (!(headComponent instanceof AbstractUIMeta) || !"viewport".equals(((AbstractUIMeta)headComponent).getName())) continue;
                return true;
            }
            return false;
        }
    }
}

