/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugNavigationHandler
extends NavigationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DebugNavigationHandler.class);
    private NavigationHandler navigationHandler;

    public DebugNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handle Navigation context: " + facesContext + " fromAction: '" + fromAction + "' outcome: '" + outcome + "'");
        }
        if (outcome != null && facesContext.getPartialViewContext().isAjaxRequest()) {
            LOG.warn("An AJAX-Request should not have an outcome set: outcome='" + outcome + "'");
        }
        this.navigationHandler.handleNavigation(facesContext, fromAction, outcome);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handled Navigation context: " + facesContext + " fromAction: '" + fromAction + "' outcome: '" + outcome + "'");
        }
    }
}

