/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;

public final class JavascriptUtils {
    private static final Log log = LogFactory.getLog(JavascriptUtils.class);
    public static final String JAVASCRIPT_DETECTED = JavascriptUtils.class.getName() + ".JAVASCRIPT_DETECTED";
    private static final String AUTO_SCROLL_PARAM = "autoScroll";
    private static final String AUTO_SCROLL_FUNCTION = "getScrolling()";
    private static final String OLD_VIEW_ID = JavascriptUtils.class + ".OLD_VIEW_ID";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "in", "instanceof", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with"));

    private JavascriptUtils() {
    }

    public static String getValidJavascriptNameAsInRI(String origIdentifier) {
        return origIdentifier.replaceAll("-", "\\$_");
    }

    public static String getValidJavascriptName(String s, boolean checkForReservedWord) {
        if (checkForReservedWord && RESERVED_WORDS.contains(s)) {
            return s + "_";
        }
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static String encodeString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    app = "\\\\";
                    break;
                }
                case '\"': {
                    app = "\\\"";
                    break;
                }
                case '\'': {
                    app = "\\'";
                    break;
                }
                case '\n': {
                    app = "\\n";
                    break;
                }
                case '\r': {
                    app = "\\r";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean isJavascriptAllowed(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        if (myfacesConfig.isAllowJavascript()) {
            if (myfacesConfig.isDetectJavascript()) {
                return JavascriptUtils.isJavascriptDetected(externalContext);
            }
            return true;
        }
        return false;
    }

    public static boolean isRenderClearJavascriptOnButton(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        return myfacesConfig.isRenderClearJavascriptOnButton();
    }

    public static boolean isSaveFormSubmitLinkIE(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        return myfacesConfig.isSaveFormSubmitLinkIE();
    }

    public static void setJavascriptDetected(HttpSession session, boolean value) {
        session.setAttribute(JAVASCRIPT_DETECTED, (Object)value);
    }

    public static boolean isJavascriptDetected(ExternalContext externalContext) {
        Boolean sessionValue = (Boolean)externalContext.getSessionMap().get(JAVASCRIPT_DETECTED);
        return sessionValue != null && sessionValue != false;
    }

    public static void setOldViewId(ExternalContext externalContext, String viewId) {
        externalContext.getRequestMap().put(OLD_VIEW_ID, viewId);
    }

    public static String getOldViewId(ExternalContext externalContext) {
        return (String)externalContext.getRequestMap().get(OLD_VIEW_ID);
    }
}

