/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.radio.HtmlRadio;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRadioRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlRadioRenderer
extends HtmlRadioRendererBase {
    private static final String LAYOUT_SPREAD = "spread";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlRadio) {
            this.renderRadio(context, (HtmlRadio)component);
        } else if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(context, component);
        } else if (component instanceof UISelectOne) {
            String layout = this.getLayout(component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderRadio(FacesContext facesContext, HtmlRadio radio) throws IOException {
        Converter converter;
        String forAttr = radio.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = radio.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = radio.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + radio.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectOne)) {
            throw new IllegalStateException("UISelectOne expected");
        }
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        List selectItemList = RendererUtils.getSelectItemList(uiSelectOne);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiSelectOne);
        }
        catch (FacesException e) {
            converter = null;
        }
        Object currentValue = RendererUtils.getObjectValue((UIComponent)uiSelectOne);
        currentValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, currentValue);
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, selectItem.getValue());
        ResponseWriter writer = facesContext.getResponseWriter();
        String itemId = this.renderRadio(facesContext, (UIInput)uiSelectOne, radio, itemStrValue, selectItem.isDisabled(), itemStrValue.equals(currentValue), false, index);
        boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)uiSelectOne);
        boolean itemDisabled = selectItem.isDisabled();
        boolean disabled = componentDisabled || itemDisabled;
        HtmlRadioRenderer.renderLabel(writer, (UIComponent)radio, (UIComponent)uiSelectOne, itemId, selectItem, disabled);
    }

    protected String renderRadio(FacesContext facesContext, UIInput uiComponent, HtmlRadio radio, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = radio.getId() != null && !radio.getId().startsWith("j_id") ? radio.getClientId(facesContext) : (itemNum == null ? null : clientId + ':' + itemNum);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRadioRenderer.renderHTMLAttributes(writer, (UIComponent)radio, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, (UIComponent)uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    public static void renderLabel(ResponseWriter writer, UIComponent radio, UIComponent component, String forClientId, SelectItem item, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        if (disabled) {
            labelClass = (String)radio.getAttributes().get("disabledClass");
            if (labelClass == null) {
                labelClass = (String)component.getAttributes().get("disabledClass");
            }
        } else {
            labelClass = (String)radio.getAttributes().get("enabledClass");
            if (labelClass == null) {
                labelClass = (String)component.getAttributes().get("enabledClass");
            }
        }
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write("&#160;");
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    private static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent radio, UIComponent selectOne, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            Object value = radio.getAttributes().get(attrName);
            if (value == null) {
                value = selectOne.getAttributes().get(attrName);
            }
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlRadio)) {
            super.decode(facesContext, uiComponent);
        }
    }
}

