/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.jsvalueset;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.myfaces.custom.jsvalueset.HtmlJsValueSet;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class HtmlJsValueSetRenderer
extends HtmlRenderer {
    private void writeValue(String varName, StringBuffer valueSb, StringBuffer prependSb, Object value) throws IOException {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value == null) {
            valueSb.append(this.getValueString(value));
        } else if (value instanceof Object[]) {
            Object[] objs = (Object[])value;
            valueSb.append("[");
            String comma = "";
            for (int i = 0; i < objs.length; ++i) {
                valueSb.append(comma);
                this.writeValue(varName + "_h" + i, valueSb, prependSb, objs[i]);
                comma = ",";
            }
            valueSb.append("]");
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            valueSb.append("[");
            String comma = "";
            int i = 0;
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                valueSb.append(comma);
                this.writeValue(varName + "_h" + i, valueSb, prependSb, iterator.next());
                comma = ",";
                ++i;
            }
            valueSb.append("]");
        } else if (value instanceof Map) {
            Map map = (Map)value;
            varName = varName + "_hm";
            prependSb.append("var ").append(varName).append("=new Object();\n");
            Iterator it = map.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                StringBuffer helpValueSb = new StringBuffer();
                StringBuffer helpHelpSb = new StringBuffer();
                this.writeValue(varName + "_h" + i, helpValueSb, helpHelpSb, entry.getValue());
                prependSb.append(helpHelpSb);
                prependSb.append(varName).append("[").append(this.getValueString(entry.getKey())).append("]=");
                prependSb.append(helpValueSb).append(";\n");
                ++i;
            }
            valueSb.append(varName);
        } else {
            throw new IOException("Type of value not handled. Allowed are String, Number, Boolean, Object[], Collection, Map. Type of value : " + value.getClass());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, HtmlJsValueSet.class);
        HtmlJsValueSet jsValue = (HtmlJsValueSet)component;
        Object value = jsValue.getValue();
        String varName = jsValue.getName();
        ResponseWriter writer = this.getFacesContext().getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer valueSb = new StringBuffer("var " + varName + "=");
        StringBuffer prependSb = new StringBuffer("");
        this.writeValue(varName, valueSb, prependSb, value);
        writer.write(prependSb.toString());
        writer.write(valueSb.toString() + ";\n");
        writer.endElement("script");
    }

    private String getValueString(Object value) throws IOException {
        if (value instanceof String) {
            return "'" + StringEscapeUtils.escapeJavaScript((String)value.toString()) + "'";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value == null) {
            return "null";
        }
        throw new IOException("value : " + value + " is of type : " + value.getClass() + ", provide a method to convert this.");
    }

    protected Application getApplication() {
        return this.getFacesContext().getApplication();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

