/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEventUtils {
    public static long getCommonEventsMarked(UIComponent component) {
        Long commonEvents = (Long)component.getAttributes().get("oam.COMMON_EVENTS_MARKED");
        if (commonEvents == null) {
            commonEvents = 0L;
        }
        return commonEvents;
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, targetClientId, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        return CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, component.getClientId(facesContext), eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        List<ClientBehavior> cbl;
        List<ClientBehavior> list = cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if (cbl == null || cbl.size() == 0) {
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
        }
        if (cbl.size() > 1 || cbl.size() == 1 && attributeValue != null) {
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, HtmlRendererUtils.buildBehaviorChain(facesContext, component, targetClientId, eventName, eventParameters, clientBehaviors, attributeValue, ""));
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cbl.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)targetClientId, eventParameters)));
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, uiComponent.getClientId(facesContext), clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x2000L) != 0L || (commonEventsMarked & 2L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, targetClientId, "click", clientBehaviors, "onclick");
        }
        if ((commonPropertiesMarked & 0x4000L) != 0L || (commonEventsMarked & 4L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, targetClientId, "dblclick", clientBehaviors, "ondblclick");
        }
        if ((commonPropertiesMarked & 0x8000L) != 0L || (commonEventsMarked & 8L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, targetClientId, "mousedown", clientBehaviors, "onmousedown");
        }
        if ((commonPropertiesMarked & 0x10000L) != 0L || (commonEventsMarked & 0x10L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, targetClientId, "mouseup", clientBehaviors, "onmouseup");
        }
        if ((commonPropertiesMarked & 0x20000L) != 0L || (commonEventsMarked & 0x20L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, targetClientId, "mouseover", clientBehaviors, "onmouseover");
        }
        if ((commonPropertiesMarked & 0x40000L) != 0L || (commonEventsMarked & 0x40L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, targetClientId, "mousemove", clientBehaviors, "onmousemove");
        }
        if ((commonPropertiesMarked & 0x80000L) != 0L || (commonEventsMarked & 0x80L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, targetClientId, "mouseout", clientBehaviors, "onmouseout");
        }
        if ((commonPropertiesMarked & 0x100000L) != 0L || (commonEventsMarked & 0x100L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, targetClientId, "keypress", clientBehaviors, "onkeypress");
        }
        if ((commonPropertiesMarked & 0x200000L) != 0L || (commonEventsMarked & 0x200L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, targetClientId, "keydown", clientBehaviors, "onkeydown");
        }
        if ((commonPropertiesMarked & 0x400000L) != 0L || (commonEventsMarked & 0x400L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, targetClientId, "keyup", clientBehaviors, "onkeyup");
        }
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonEventUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, uiComponent.getClientId(facesContext), clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x4000L) != 0L || (commonEventsMarked & 4L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, targetClientId, "dblclick", clientBehaviors, "ondblclick");
        }
        if ((commonPropertiesMarked & 0x8000L) != 0L || (commonEventsMarked & 8L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, targetClientId, "mousedown", clientBehaviors, "onmousedown");
        }
        if ((commonPropertiesMarked & 0x10000L) != 0L || (commonEventsMarked & 0x10L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, targetClientId, "mouseup", clientBehaviors, "onmouseup");
        }
        if ((commonPropertiesMarked & 0x20000L) != 0L || (commonEventsMarked & 0x20L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, targetClientId, "mouseover", clientBehaviors, "onmouseover");
        }
        if ((commonPropertiesMarked & 0x40000L) != 0L || (commonEventsMarked & 0x40L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, targetClientId, "mousemove", clientBehaviors, "onmousemove");
        }
        if ((commonPropertiesMarked & 0x80000L) != 0L || (commonEventsMarked & 0x80L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, targetClientId, "mouseout", clientBehaviors, "onmouseout");
        }
        if ((commonPropertiesMarked & 0x100000L) != 0L || (commonEventsMarked & 0x100L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, targetClientId, "keypress", clientBehaviors, "onkeypress");
        }
        if ((commonPropertiesMarked & 0x200000L) != 0L || (commonEventsMarked & 0x200L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, targetClientId, "keydown", clientBehaviors, "onkeydown");
        }
        if ((commonPropertiesMarked & 0x400000L) != 0L || (commonEventsMarked & 0x400L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, targetClientId, "keyup", clientBehaviors, "onkeyup");
        }
    }

    public static void renderBehaviorizedFieldEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, targetClientId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonPropertiesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        }
        if ((commonPropertiesMarked & 0x800L) != 0L || (commonEventsMarked & 0x4000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "change", clientBehaviors, "onchange");
        }
        if ((commonPropertiesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, targetClientId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnfocus(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        }
        if ((commonPropertiesMarked & 0x800L) != 0L || (commonEventsMarked & 0x4000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "change", clientBehaviors, "onchange");
        }
        if ((commonPropertiesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, targetClientId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, uiComponent.getClientId(facesContext), clientBehaviors);
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, targetClientId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonPropertiesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        }
        if ((commonPropertiesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, targetClientId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, uiComponent.getClientId(facesContext), clientBehaviors);
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, long commonPropertiesMarked, long commonEventsMarked, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if ((commonPropertiesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, targetClientId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonPropertiesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonEventUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        }
    }
}

