/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.ImageType;
import org.apache.myfaces.trinidadinternal.image.util.MapArea;
import org.apache.myfaces.trinidadinternal.image.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.image.xml.encode.XMLEncoder;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ColorParserFactory;
import org.apache.myfaces.trinidadinternal.image.xml.parse.FontParserFactory;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ImageMapParserFactory;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ImageProviderRequestParserFactory;
import org.apache.myfaces.trinidadinternal.image.xml.parse.TextParserFactory;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.ParserFactory;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProviderRequestUtils {
    private static ParserManager _sManager;
    private static final String _ENCODER_ERROR = "Missing XMLEncoder for ";
    private static final Map<Object, Object> _EMPTY_MAP;

    public static ImageProviderRequest createImageProviderRequest(ImageContext context, XMLProvider provider, InputSource source) throws IOException, SAXException {
        return (ImageProviderRequest)ImageProviderRequestUtils._parse(context, provider, source, ImageProviderRequest.class);
    }

    public static ImageProviderRequest[] createImageProviderRequests(ImageContext context, XMLProvider provider, InputSource source) throws IOException, SAXException {
        return (ImageProviderRequest[])ImageProviderRequestUtils._parse(context, provider, source, ImageProviderRequest[].class);
    }

    public static void encodeImageProviderRequest(ImageContext context, String namespaceURI, String localName, ImageType type, Map<Object, Object> properties, Map<Object, Object> responseProperties, PrintWriter writer) throws IllegalArgumentException {
        XMLEncoder encoder = (XMLEncoder)type.getProperty(ImageType.XML_ENCODER_PROPERTY);
        if (encoder == null) {
            throw new IllegalArgumentException(_ENCODER_ERROR + type);
        }
        if (responseProperties == null) {
            responseProperties = _EMPTY_MAP;
        }
        writer.print("<ImageMetadata version=\"2.0\"");
        writer.print(" xmlns=\"");
        writer.print("http://myfaces.apache.org/uix/image");
        writer.println("\">");
        encoder.encodeXML(context, namespaceURI, localName, properties, responseProperties, writer);
        writer.println("</ImageMetadata>");
        writer.flush();
    }

    public static MapArea[] createMapAreas(ImageContext context, XMLProvider provider, InputSource source) throws IOException, SAXException {
        return (MapArea[])ImageProviderRequestUtils._parse(context, provider, source, MapArea[].class);
    }

    public static void encodeImageMapAreas(ImageContext context, String namespaceURI, String localName, MapArea[] areas, PrintWriter writer) {
        if (areas == null) {
            return;
        }
        if (localName == null) {
            throw new NullPointerException("Null localName");
        }
        writer.print('<');
        writer.print(localName);
        if (namespaceURI != null) {
            ImageProviderRequestUtils._encodeAttribute("xmlns", namespaceURI, writer);
        }
        writer.println('>');
        for (int i = 0; i < areas.length; ++i) {
            writer.print('<');
            writer.print("area");
            MapArea area = areas[i];
            ImageProviderRequestUtils._encodeAttribute("shape", area.getShape(), writer);
            ImageProviderRequestUtils._encodeAttribute("coords", area.getCoordinatesString(), writer);
            writer.println("/>");
        }
        writer.print("</");
        writer.print(localName);
        writer.println('>');
    }

    public static ParserManager createDefaultManager() {
        ParserManager manager = new ParserManager();
        ImageProviderRequestParserFactory.sharedInstance().registerSelf(manager, "http://myfaces.apache.org/uix/image");
        ColorParserFactory.sharedInstance().registerSelf(manager, "http://myfaces.apache.org/uix/image");
        FontParserFactory.sharedInstance().registerSelf(manager, "http://myfaces.apache.org/uix/image");
        TextParserFactory.sharedInstance().registerSelf(manager, "http://myfaces.apache.org/uix/image");
        ImageMapParserFactory.sharedInstance().registerSelf(manager, "http://myfaces.apache.org/uix/image");
        return manager;
    }

    public static void registerParserFactory(Class<?> expectedType, String namespace, ParserFactory factory) {
        ImageProviderRequestUtils._getDefaultManager().registerFactory(expectedType, namespace, factory);
    }

    public static void unregisterParserFactory(Class<?> expectedType, String namespace) {
        ImageProviderRequestUtils._getDefaultManager().unregisterFactory(expectedType, namespace);
    }

    private static void _encodeAttribute(String name, String value, PrintWriter writer) {
        writer.print(' ');
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.print('\"');
    }

    private static ParserManager _getDefaultManager() {
        if (_sManager == null) {
            _sManager = ImageProviderRequestUtils.createDefaultManager();
        }
        return _sManager;
    }

    private static Object _parse(ImageContext context, XMLProvider provider, InputSource source, Class<?> expectedClass) throws IOException, SAXException {
        ParserManager manager = ImageProviderRequestUtils._getDefaultManager();
        TreeBuilder builder = new TreeBuilder(manager, expectedClass);
        ParseContextImpl parseContext = new ParseContextImpl();
        ResourceBundle bundle = (ResourceBundle)context.getProperty("http://myfaces.apache.org/uix/image", XMLConstants.RESOURCE_BUNDLE_PROPERTY);
        if (bundle != null) {
            parseContext.setProperty("http://myfaces.apache.org/uix/image", XMLConstants.RESOURCE_BUNDLE_PROPERTY, bundle);
        }
        parseContext.setProperty("http://myfaces.apache.org/uix/image", XMLConstants.LOCALE_CONTEXT_PROPERTY, context.getLocaleContext());
        return builder.parse(provider, source, parseContext);
    }

    private ImageProviderRequestUtils() {
    }

    static {
        _EMPTY_MAP = new ArrayMap(0);
    }
}

