/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.Base64InputStream;
import org.apache.myfaces.trinidad.util.Base64OutputStream;
import org.apache.myfaces.trinidadinternal.util.ObjectInputStreamResolveClass;

public class CoreResponseStateManager
extends ResponseStateManager {
    public static final String FORM_FIELD_NAME = "org.apache.myfaces.trinidad.faces.FORM";
    private static final int _BUFFER_SIZE = 2048;
    private static final String _CACHED_SERIALIZED_VIEW = "org.apache.myfaces.trinidadinternal.renderkit.CACHED_SERIALIZED_VIEW";
    private static final String _TOKEN_PREFIX = "!";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CoreResponseStateManager.class);

    public Object getState(FacesContext context, String viewId) {
        Object state = context.getExternalContext().getRequestMap().get("org.apache.myfaces.trinidadinternal.application.StateManagerImp.RESPONSE_STATE_MANAGER_STATE");
        if (state != null) {
            return state;
        }
        return super.getState(context, viewId);
    }

    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"hidden", null);
        rw.writeAttribute("name", (Object)"javax.faces.ViewState", null);
        String s = this.encodeSerializedViewAsString(serializedView);
        rw.writeAttribute("value", (Object)s, null);
        rw.endElement("input");
    }

    public boolean isPostback(FacesContext context) {
        Map requestParams = context.getExternalContext().getRequestParameterMap();
        return requestParams.containsKey("javax.faces.ViewState");
    }

    protected String encodeSerializedViewAsString(StateManager.SerializedView serializedView) throws IOException {
        if (serializedView.getState() == null && serializedView.getStructure() instanceof String) {
            return _TOKEN_PREFIX + serializedView.getStructure();
        }
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        Base64OutputStream b64_out = new Base64OutputStream((Writer)bw);
        GZIPOutputStream zip = new GZIPOutputStream((OutputStream)b64_out, 2048);
        ObjectOutputStream output = new ObjectOutputStream(zip);
        output.writeObject(serializedView.getStructure());
        output.writeObject(serializedView.getState());
        output.close();
        String retVal = sw.toString();
        assert (!retVal.startsWith(_TOKEN_PREFIX));
        return retVal;
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Object[] view = this._restoreSerializedView(context);
        if (view == null) {
            return null;
        }
        return view[0];
    }

    public Object getComponentStateToRestore(FacesContext context) {
        Object[] view = this._restoreSerializedView(context);
        if (view == null) {
            return null;
        }
        return view[1];
    }

    public String getViewState(FacesContext context, Object state) {
        StateManager.SerializedView serializedView = this._getSerializedView(context, state);
        try {
            return this.encodeSerializedViewAsString(serializedView);
        }
        catch (IOException e) {
            throw new FacesException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StateManager.SerializedView _getSerializedView(FacesContext context, Object state) {
        StateManager stateManager;
        if (state instanceof StateManager.SerializedView) {
            return (StateManager.SerializedView)state;
        }
        if (!(state instanceof Object[])) throw new IllegalArgumentException(_LOG.getMessage("UNEXPECTED_STATE"));
        Object[] stateArray = (Object[])state;
        if (stateArray.length != 2) throw new IllegalArgumentException(_LOG.getMessage("UNEXPECTED_STATE"));
        StateManager stateManager2 = stateManager = context.getApplication().getStateManager();
        stateManager2.getClass();
        return new StateManager.SerializedView(stateManager2, stateArray[0], stateArray[1]);
    }

    public static String getStateToken(ExternalContext external) {
        return CoreResponseStateManager._tokenStringFromStateString(CoreResponseStateManager._getStateString(external));
    }

    private static String _getStateString(ExternalContext external) {
        return (String)external.getRequestParameterMap().get("javax.faces.ViewState");
    }

    private static String _tokenStringFromStateString(String stateString) {
        if (stateString != null && stateString.startsWith(_TOKEN_PREFIX)) {
            return stateString.substring(_TOKEN_PREFIX.length());
        }
        return null;
    }

    private Object[] _restoreSerializedView(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        Map requestMap = external.getRequestMap();
        Object[] view = (Object[])requestMap.get(_CACHED_SERIALIZED_VIEW);
        if (view == null) {
            String stateString = CoreResponseStateManager._getStateString(external);
            String tokenString = CoreResponseStateManager._tokenStringFromStateString(stateString);
            if (tokenString != null) {
                view = new Object[]{tokenString, null};
            } else if (stateString != null) {
                StringReader sr = new StringReader(stateString);
                BufferedReader br = new BufferedReader(sr);
                Base64InputStream b64_in = new Base64InputStream((Reader)br);
                try {
                    ObjectInputStreamResolveClass ois = new ObjectInputStreamResolveClass(new GZIPInputStream((InputStream)b64_in, 2048));
                    Object structure = ois.readObject();
                    Object state = ois.readObject();
                    ois.close();
                    view = new Object[]{structure, state};
                }
                catch (OptionalDataException ode) {
                    _LOG.severe((Throwable)ode);
                }
                catch (ClassNotFoundException cnfe) {
                    _LOG.severe((Throwable)cnfe);
                }
                catch (IOException ioe) {
                    _LOG.severe((Throwable)ioe);
                }
            }
            if (view != null) {
                requestMap.put(_CACHED_SERIALIZED_VIEW, view);
            }
        }
        return view;
    }
}

