/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.awt.Color;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProvider;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.ImageProviderResponse;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.LookAndFeel;
import org.apache.myfaces.trinidadinternal.ui.laf.base.ColorizedLafIconProvider;
import org.apache.myfaces.trinidadinternal.ui.laf.base.Icon;
import org.apache.myfaces.trinidadinternal.ui.laf.base.IconKey;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafConstants;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AccentedLafIconProvider
extends ColorizedLafIconProvider
implements XhtmlLafConstants {
    private static final String _ACCENT_COLOR_KEY = "_accentColor";
    private static final String _CORE_COLOR_KEY = "_coreColor";
    private static final Color _DEFAULT_ACCENT_COLOR = new Color(204, 204, 153);
    private static final Color _DEFAULT_CORE_COLOR = new Color(51, 102, 153);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AccentedLafIconProvider.class);

    protected abstract Icon getIcon(IconKey var1);

    protected boolean isTransparent(IconKey iconKey) {
        return true;
    }

    protected abstract ImageProviderRequest createCoreIconRequest(ImageContext var1, String var2, Class<LookAndFeel> var3, int var4, Color var5, Color var6, NameResolver var7);

    protected abstract ImageProviderRequest createAccentIconRequest(ImageContext var1, String var2, Class<LookAndFeel> var3, int var4, Color var5, Color var6, NameResolver var7);

    @Override
    public ImageProviderResponse getColorizedIcon(UIXRenderingContext context, IconKey iconKey) {
        ImageProviderRequest request;
        ImageProvider provider = (ImageProvider)context.getProperty("http://myfaces.apache.org/uix/image", ImageConstants.IMAGE_PROVIDER_PROPERTY);
        Icon icon = this.getIcon(iconKey);
        String iconName = null;
        if (icon != null) {
            iconName = icon.getName();
        }
        if (provider == null) {
            if (_LOG.isWarning()) {
                _LOG.warning("CANNOT_GET_IMAGE_PROVIDER_FOR_ICON", (Object)iconName);
            }
            return null;
        }
        ImageContext imageContext = context.getImageContext();
        ImageProviderResponse response = provider.getImage(imageContext, request = this._getIconRequest(context, iconKey));
        if (response == null && _LOG.isWarning()) {
            _LOG.warning("CANNOT_GET_COLORIZED_ICON", (Object)iconName);
        }
        return response;
    }

    private ImageProviderRequest _getIconRequest(UIXRenderingContext context, IconKey iconKey) {
        Icon icon = this.getIcon(iconKey);
        String source = null;
        boolean isDirectionIndependent = false;
        boolean isCoreColor = false;
        Class<LookAndFeel> lookAndFeel = null;
        NameResolver resolver = null;
        if (icon != null) {
            source = icon.getName();
            isDirectionIndependent = icon.isSymmetric();
            isCoreColor = icon.isCoreColor();
            lookAndFeel = icon.getLookAndFeel();
            resolver = icon.getNameResolver();
        }
        if (source == null) {
            _LOG.warning("CANNOT_FIND_ICON_WITH_GIVEN_KEY");
            return null;
        }
        int direction = -1;
        direction = isDirectionIndependent ? 1 : LocaleUtils.getReadingDirection(context.getLocaleContext());
        assert (direction != -1);
        Color color = null;
        ImageContext imageContext = context.getImageContext();
        color = isCoreColor ? AccentedLafIconProvider._getCoreColor(context) : AccentedLafIconProvider._getAccentColor(context);
        Color surroundingColor = this._getSurroundingColor(context, iconKey);
        if (isCoreColor) {
            return this.createCoreIconRequest(imageContext, source, lookAndFeel, direction, color, surroundingColor, resolver);
        }
        return this.createAccentIconRequest(imageContext, source, lookAndFeel, direction, color, surroundingColor, resolver);
    }

    private static Color _getCoreColor(UIXRenderingContext context) {
        return AccentedLafIconProvider._getColor(context, "OraBGColorDark", _CORE_COLOR_KEY, _DEFAULT_CORE_COLOR);
    }

    private static Color _getAccentColor(UIXRenderingContext context) {
        return AccentedLafIconProvider._getColor(context, "OraBGAccentDark", _ACCENT_COLOR_KEY, _DEFAULT_ACCENT_COLOR);
    }

    private static Color _getColor(UIXRenderingContext context, String styleClass, Object key, Color defaultColor) {
        Color color = (Color)context.getProperty("http://myfaces.apache.org/uix/ui", key);
        if (color != null) {
            return color;
        }
        if (color == null) {
            color = defaultColor;
        }
        context.setProperty("http://myfaces.apache.org/uix/ui", key, color);
        return color;
    }

    private Color _getSurroundingColor(UIXRenderingContext context, IconKey iconKey) {
        if (this.isTransparent(iconKey) && !XhtmlLafUtils.supportsTransparentImages(context)) {
            return XhtmlLafUtils.getBackgroundColor(context);
        }
        return null;
    }
}

