/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.xmlHttp;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestType;
import org.apache.myfaces.trinidadinternal.application.StateManagerImpl;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpPortletExternalContext;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpResourceResponse;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpServletRequest;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpServletResponse;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;

public class XmlHttpConfigurator
extends Configurator {
    private static int _ERROR_COUNT = 0;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XmlHttpConfigurator.class);

    public static ServletRequest getAjaxServletRequest(ServletRequest request) {
        return new XmlHttpServletRequest(request);
    }

    public ExternalContext getExternalContext(ExternalContext externalContext) {
        if (CoreRenderKit.isPartialRequest(externalContext)) {
            StateManagerImpl.reuseRequestTokenForResponse(externalContext);
            RequestType type = ExternalContextUtils.getRequestType((ExternalContext)externalContext);
            switch (type) {
                case SERVLET: {
                    if (!ExternalContextUtils.isHttpServletRequest((ExternalContext)externalContext)) break;
                    externalContext.setResponse((Object)new XmlHttpServletResponse((ExternalContext)externalContext));
                    break;
                }
                case RESOURCE: {
                    externalContext = new XmlHttpPortletExternalContext((ExternalContext)externalContext);
                    externalContext.setResponse((Object)new XmlHttpResourceResponse((ExternalContext)externalContext));
                }
            }
        }
        return externalContext;
    }

    public static void sendXmlRedirect(PrintWriter writer, String url) throws IOException {
        XmlResponseWriter rw = new XmlResponseWriter(writer, "UTF-8");
        rw.startDocument();
        rw.startElement("partial-response", null);
        rw.startElement("redirect", null);
        rw.writeAttribute("url", url, null);
        rw.endElement("redirect");
        rw.endElement("partial-response");
        rw.endDocument();
        rw.close();
    }

    public static void handleError(ExternalContext ec, Throwable t) throws IOException {
        String error = XmlHttpConfigurator._getErrorString();
        _LOG.severe(error, t);
        ServletResponse response = (ServletResponse)ec.getResponse();
        PrintWriter writer = response.getWriter();
        XmlResponseWriter rw = new XmlResponseWriter(writer, "UTF-8");
        rw.startDocument();
        rw.startElement("partial-response", null);
        rw.startElement("error", null);
        rw.startElement("error-name", null);
        rw.writeText(500, null);
        rw.endElement("error-name");
        String errorMessage = XmlHttpConfigurator._getErrorMessage(error);
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application application = factory.getApplication();
        if (application.getProjectStage() != ProjectStage.Production) {
            errorMessage = XmlHttpConfigurator._getExceptionString(t) + errorMessage;
        }
        rw.startElement("error-message", null);
        rw.writeText(errorMessage, null);
        rw.endElement("error-message");
        rw.endElement("error");
        rw.endElement("partial-response");
        rw.endDocument();
        rw.close();
    }

    private static String _getExceptionString(Throwable t) {
        Throwable cause;
        while (XmlHttpConfigurator._isUninterestingThrowable(t) && (cause = t.getCause()) != null) {
            t = cause;
        }
        String message = t.getMessage();
        if (message == null || "".equals(message)) {
            message = t.getClass().getName();
        }
        return message + "\n\n";
    }

    private static boolean _isUninterestingThrowable(Throwable t) {
        return t instanceof ServletException || t instanceof JspException || t instanceof FacesException || t instanceof InvocationTargetException;
    }

    private static String _getErrorString() {
        return _LOG.getMessage("EXC_PPR_ERROR_PREFIX", (Object)XmlHttpConfigurator._getErrorCount());
    }

    private static String _getErrorMessage(String error) {
        return _LOG.getMessage("EXC_PLEASE_SEE_ERROR_LOG", (Object)error);
    }

    private static synchronized int _getErrorCount() {
        return ++_ERROR_COUNT;
    }
}

