/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public class ListFromCollection {
    private Map<Collection<?>, List<?>> _map = new MakeList();
    private int _size = _DEFAULT_SIZE;
    private static int _DEFAULT_SIZE = 50;

    public Map<Collection<?>, List<?>> getList() {
        return this._map;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    private static class ListImpl
    extends AbstractList<Object> {
        private final Collection<? extends Object> _c;
        private final int _bufferSize;
        private final int _cSize;
        private int _offset;
        private ArrayList<Object> _buffer;

        public ListImpl(Collection<?> c, int size) {
            this._c = c;
            this._cSize = c.size();
            this._bufferSize = size == 0 ? this._cSize : Math.min(size, this._cSize);
            this._buffer = new ArrayList(this._bufferSize);
            this._offset = -1;
        }

        @Override
        public int size() {
            return this._cSize;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this._cSize) {
                throw new IndexOutOfBoundsException();
            }
            int offset = index / this._bufferSize * this._bufferSize;
            if (offset != this._offset) {
                this._loadBuffer(offset);
                this._offset = offset;
            }
            return this._buffer.get(index - this._offset);
        }

        private void _loadBuffer(int offset) {
            int i;
            Iterator<? extends Object> iter = this._c.iterator();
            for (i = 0; i < offset; ++i) {
                assert (iter.hasNext());
                iter.next();
            }
            this._buffer.clear();
            for (int count = 0; count < this._bufferSize && i < this._cSize; ++i, ++count) {
                assert (iter.hasNext());
                this._buffer.add(iter.next());
            }
        }
    }

    private class MakeList
    extends AbstractMap<Collection<?>, List<?>> {
        private MakeList() {
        }

        @Override
        public List<?> get(Object o) {
            if (!(o instanceof Collection)) {
                return null;
            }
            if (o instanceof List && o instanceof RandomAccess) {
                return (List)o;
            }
            Collection c = (Collection)o;
            if (c.isEmpty()) {
                return Collections.emptyList();
            }
            return new ListImpl(c, ListFromCollection.this.getSize());
        }

        @Override
        public Set<Map.Entry<Collection<?>, List<?>>> entrySet() {
            return Collections.emptySet();
        }
    }
}

