/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.pda;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.core.output.CoreMessages;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.ui.BaseMutableUINode;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.MessageBoxUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.MessageWrapper;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

@Deprecated
public class MessageBoxRenderer
extends XhtmlLafRenderer {
    private static final String[] _ICON_NAMES = new String[]{"af|messages::info-icon", "af|messages::warning-icon", "af|messages::error-icon", "af|messages::confirmation-icon"};
    private static final int _INFORMATION_TYPE = 0;
    private static final int _WARNING_TYPE = 1;
    private static final int _ERROR_TYPE = 2;
    private static final int _CONFIRMATION_TYPE = 3;
    private static final String _INFORMATION_KEY = "af_messages.INFORMATION";
    private static final String _WARNING_KEY = "af_messages.WARNING";
    private static final String _ERROR_KEY = "af_messages.ERROR";
    private static final String _CONFIRMATION_KEY = "af_messages.CONFIRMATION";
    private static final String[] _MESSAGE_TYPE_KEYS = new String[]{"af_messages.INFORMATION", "af_messages.WARNING", "af_messages.ERROR", "af_messages.CONFIRMATION"};
    private static final Object _MB_IS_RENDERED = new Object();

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        if (MessageBoxUtils.sIsRendered(context, node, !Boolean.TRUE.equals(MessageBoxRenderer.getAttributeValue(context, node, GLOBAL_ONLY_ATTR, null)))) {
            super.prerender(context, node);
            context.setLocalProperty(_MB_IS_RENDERED, Boolean.TRUE);
        }
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        Object isRendered = context.getLocalProperty(0, _MB_IS_RENDERED, null);
        if (Boolean.TRUE.equals(isRendered)) {
            super.postrender(context, node);
        }
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        Object isRendered = context.getLocalProperty(0, _MB_IS_RENDERED, null);
        if (Boolean.TRUE.equals(isRendered)) {
            int messageType = this._getMessageTypeBySeverity(MessageBoxUtils.sGetMaxSeverity(context));
            Icon icon = this._getIcon(context, messageType);
            String messageStyle = this._getMessageTextStyle(messageType);
            Object message = node.getAttributeValue(context, MESSAGE_ATTR);
            this._renderLine(context, node, messageStyle, icon, messageType, message);
        }
    }

    private final void _renderLine(UIXRenderingContext context, UINode node, String messageStyle, Icon icon, int messageType, Object message) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MarlinBean text = new MarlinBean("styledText");
        RenderingContext arc = RenderingContext.getCurrentInstance();
        FacesContext fContext = context.getFacesContext();
        if (icon != null) {
            icon.renderIcon(fContext, arc, null);
            writer.writeText((Object)NBSP_STRING, null);
        }
        String messageKey = _MESSAGE_TYPE_KEYS[messageType];
        text.setStyleClass(messageStyle);
        text.setAttributeValue(TEXT_ATTR, MessageBoxRenderer.getTranslatedString(context, messageKey));
        writer.startElement("table", null);
        MessageBoxRenderer.renderStyleClassAttribute(context, "af|messages::body");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.startElement("b", node.getUIComponent());
        text.render(context);
        if (message != null) {
            writer.startElement("br", null);
            writer.endElement("br");
            writer.writeText(message, CoreMessages.MESSAGE_KEY.getName());
        }
        writer.endElement("b");
        boolean useList = MessageBoxUtils.sMultipleMessages(context, !Boolean.TRUE.equals(MessageBoxRenderer.getAttributeValue(context, node, GLOBAL_ONLY_ATTR, null)));
        if (useList) {
            writer.startElement("ol", null);
        } else {
            writer.startElement("div", null);
        }
        MessageBoxRenderer.renderStyleClassAttribute(context, "af|messages::list");
        this._renderMessages(context, writer, true, useList);
        if (!Boolean.TRUE.equals(MessageBoxRenderer.getAttributeValue(context, node, GLOBAL_ONLY_ATTR, null))) {
            this._renderMessages(context, writer, false, useList);
        }
        if (useList) {
            writer.endElement("ol");
        } else {
            writer.endElement("div");
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void _renderMessages(UIXRenderingContext context, ResponseWriter writer, boolean isGlobal, boolean useList) throws IOException {
        Iterator<MessageWrapper> itr;
        BaseMutableUINode currentChild = null;
        Iterator<MessageWrapper> iterator = itr = isGlobal ? MessageBoxUtils.sGetGlobalsIterator(context) : MessageBoxUtils.sGetClientsIterator(context);
        while (itr.hasNext()) {
            MessageWrapper msg = itr.next();
            if (useList) {
                writer.startElement("li", null);
            }
            String summary = msg.getSummary();
            String detail = msg.getDetail();
            if (isGlobal) {
                this._writeGlobalMsg(context, writer, summary, detail);
            } else {
                currentChild = this._writeClientMsg(context, writer, summary, msg, currentChild);
            }
            if (!useList) continue;
            writer.endElement("li");
        }
    }

    private void _writeGlobalMsg(UIXRenderingContext context, ResponseWriter writer, String summary, String detail) throws IOException {
        String text = MessageUtils.getGlobalMessage(context, summary, detail);
        if (this.isTextFormatted(text)) {
            this.renderFormattedText(context, text);
        } else if (text != null) {
            writer.writeText((Object)text, null);
        }
    }

    private BaseMutableUINode _writeClientMsg(UIXRenderingContext context, ResponseWriter writer, String summary, MessageWrapper msg, BaseMutableUINode currentChild) throws IOException {
        String description;
        if (summary != null) {
            String[] parameters = new String[]{summary};
            String pattern = MessageBoxRenderer.getTranslatedString(context, "af_messages.LIST_FORMAT_private");
            description = this.formatString(context, pattern, parameters);
        } else {
            description = "";
        }
        currentChild = this._generateChild(msg, currentChild);
        currentChild.render(context);
        if (this.isTextFormatted(summary)) {
            this.renderFormattedText(context, description);
        } else if (description != null) {
            writer.writeText((Object)description, null);
        }
        return currentChild;
    }

    private BaseMutableUINode _generateChild(MessageWrapper msg, BaseMutableUINode cachedChild) {
        if (cachedChild == null) {
            cachedChild = new BaseMutableUINode("http://myfaces.apache.org/uix/ui", "link");
        }
        String label = msg.getLabel();
        cachedChild.setAttributeValue(TEXT_ATTR, label);
        String anchor = null;
        String summary = null;
        if (label != null) {
            anchor = MessageUtils.getAnchor(msg.getId().toString());
            if (anchor != null) {
                anchor = "#" + anchor;
            }
            summary = msg.getSummary();
        }
        cachedChild.setAttributeValue(DESTINATION_ATTR, anchor);
        cachedChild.setAttributeValue(LONG_DESC_ATTR, summary);
        return cachedChild;
    }

    private String _getMessageTextStyle(int messageType) {
        return messageType == 2 ? "af|messages::error" : "af|messages::header";
    }

    private int _getMessageTypeBySeverity(FacesMessage.Severity severity) {
        if (FacesMessage.SEVERITY_ERROR.compareTo((Object)severity) == 0) {
            return 2;
        }
        if (FacesMessage.SEVERITY_WARN.compareTo((Object)severity) == 0) {
            return 1;
        }
        if (FacesMessage.SEVERITY_INFO.compareTo((Object)severity) == 0) {
            return 0;
        }
        return 3;
    }

    private Icon _getIcon(UIXRenderingContext context, int messageType) {
        return context.getIcon(this._getIconName(messageType));
    }

    private String _getIconName(int messageType) {
        return _ICON_NAMES[messageType];
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return null;
    }
}

