/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.missing;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.index.fielddata.DocValueBits;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregator;
import org.opensearch.search.aggregations.bucket.missing.InternalMissing;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class MissingAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final ValuesSource valuesSource;

    public MissingAggregator(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, cardinality, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final DocValueBits docsWithValue = this.valuesSource != null ? this.valuesSource.docsWithValue(ctx) : new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }
        };
        return new LeafBucketCollectorBase(sub, docsWithValue){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!docsWithValue.advanceExact(doc)) {
                    MissingAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalMissing(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMissing(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

