/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rmd\u0001B(Q\u0001UC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\to\u0002\u0011)\u0019!C\u0001q\"I\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005m\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0005\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0006\u0002Z\u0001\u0011\r\u0011\"\u0001Q\u00037B\u0001\"a\u001b\u0001A\u0003%\u0011Q\f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_B\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\t\u000f\u0005}\u0004\u0001)Q\u0005S\"Q\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u0001+a#\t\u0011\u0005M\u0005\u0001)A\u0005\u0003\u001bC!\"!&\u0001\u0005\u0004%\t\u0001UAL\u0011!\ty\n\u0001Q\u0001\n\u0005e\u0005BCAQ\u0001\t\u0007I\u0011\u0001)\u0002$\"A!Q\u0010\u0001!\u0002\u0013\t)\u000bC\u0004\u0003\u0000\u0001!IA!!\t\u0011\tM\u0005\u0001\"\u0001Q\u0005+CqAa&\u0001\t\u0003\u0011y\u0002C\u0004\u0003\u001a\u0002!\tAa\b\t\u000f\tm\u0005\u0001\"\u0001\u0003 !9!Q\u0014\u0001\u0005B\t}\u0005b\u0002BT\u0001\u0011\u0005#\u0011\u0016\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003DqA!2\u0001\t\u0003\u00119\rC\u0005\u0003X\u0002\t\n\u0011\"\u0001\u0003Z\"9!q\u001e\u0001\u0005\u0002\tE\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007\u000b\u0001A\u0011AB\u0004\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0007'Aqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004&\u0001!\taa\n\t\u0013\rE\u0002!%A\u0005\u0002\rM\u0002bBB\u001c\u0001\u0011\u00051\u0011\b\u0005\t\u0007\u0007\u0002A\u0011\u0001*\u0002p!A1Q\t\u0001\u0005\u0002A\u0013)JB\u0004\u00026\u0002\u0001\u0001+a.\t\u0015\u0005\u0015'F!A!\u0002\u0013\t9\rC\u0004\u0002J)\"\t!!4\t\u000f\u0005E'\u0006\"\u0015\u0002T\"I\u0011\u0011\u001d\u0016C\u0002\u0013\u0005\u00111\u001d\u0005\t\u0003WT\u0003\u0015!\u0003\u0002f\"I\u0011Q\u001e\u0016A\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003oT\u0003\u0019!C\u0001\u0003sD\u0001\"!@+A\u0003&\u0011\u0011\u001f\u0005\n\u0005\u0003Q\u0003\u0019!C\u0001\u0005\u0007A\u0011Ba\u0003+\u0001\u0004%\tA!\u0004\t\u0011\tE!\u0006)Q\u0005\u0005\u000bAqA!\u0006+\t\u0013\u00119\u0002C\u0004\u0003\u001e)\"\tEa\b\t\u000f\t\u0005\"\u0006\"\u0003\u0003$!9!1\u0006\u0016\u0005\n\t\r\u0002b\u0002B\u001fU\u0011%!q\b\u0005\b\u0005\u0017RC\u0011\u0001B'\u000f\u001d\u00199\u0005\u0015E\u0001\u0007\u00132aa\u0014)\t\u0002\r-\u0003bBA%{\u0011\u00051Q\n\u0005\n\u0007\u001fj$\u0019!C\u0001\u0007#B\u0001b!\u0016>A\u0003%11\u000b\u0005\b\u0007/jD\u0011AB-\u0011%\u0019i&\u0010b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0004`u\u0002\u000b\u0011BAk\u0011%\u0019\t'\u0010b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0004du\u0002\u000b\u0011BAk\u0011%\u0019)'\u0010b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0004hu\u0002\u000b\u0011BAk\u0011%\u0019I'\u0010b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0004lu\u0002\u000b\u0011BAk\u0011%\u0019i'\u0010b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0004pu\u0002\u000b\u0011BAk\u0011)\u0019\t(\u0010b\u0001\n\u0003\u00016\u0011\u000b\u0005\t\u0007gj\u0004\u0015!\u0003\u0004T!I1QO\u001f\u0012\u0002\u0013\u00051q\u000f\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(BA)S\u0003\rawn\u001a\u0006\u0002'\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001W9\n\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0007CA/a\u001b\u0005q&BA0S\u0003\u0015)H/\u001b7t\u0013\t\tgLA\u0004M_\u001e<\u0017N\\4\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u0014\u0016AB:feZ,'/\u0003\u0002hI\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\fQ\"\u001b8ji&\fGnQ8oM&<\u0007C\u00016v\u001b\u0005Y'BA)m\u0015\tig.A\u0005j]R,'O\\1mg*\u0011q\u000e]\u0001\bgR|'/Y4f\u0015\t\u0019\u0016O\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<l\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u00069An\\4ESJ\u001cX#A=\u0011\u0007ilx0D\u0001|\u0015\ta\b,\u0001\u0006d_2dWm\u0019;j_:L!A`>\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0005%|'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0005\u0005U\u0001cB/\u0002\u0018\u0005m\u0011qE\u0005\u0004\u00033q&\u0001\u0002)p_2\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0018AB2p[6|g.\u0003\u0003\u0002&\u0005}!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003S\tY#D\u0001Q\u0013\r\ti\u0003\u0015\u0002\u000b+:Lg-[3e\u0019><\u0017!\u00027pON\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u00026A\u0019!.a\u000e\n\u0007\u0005e2N\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005\u0013QI\u0007\u0003\u0003\u0007R1aXA\u0010\u0013\u0011\t9%a\u0011\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u00055\u0013qJA)\u0003'\n)&a\u0016\u0011\u0007\u0005%\u0002\u0001C\u0003i\u0013\u0001\u0007\u0011\u000eC\u0003x\u0013\u0001\u0007\u0011\u0010C\u0004\u0002\u0012%\u0001\r!!\u0006\t\u000f\u0005E\u0012\u00021\u0001\u00026!I\u0011QH\u0005\u0011\u0002\u0003\u0007\u0011qH\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003;\u0002B!a\u0018\u0002h5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0004nKR\u0014\u0018nY:\u000b\u0005\u0015\u0004\u0018\u0002BA5\u0003C\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u000511m\u001c8gS\u001e,\u0012![\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA;\u0003w\u00022aVA<\u0013\r\tI\b\u0017\u0002\u0005+:LG\u000f\u0003\u0005\u0002~5\t\t\u00111\u0001j\u0003\rAH%M\u0001\bG>tg-[4!Q\rq\u00111\u0011\t\u0004/\u0006\u0015\u0015bAAD1\nAao\u001c7bi&dW-\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\u00055\u0005\u0003BA\u0015\u0003\u001fK1!!%Q\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM]\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u00033\u00032!XAN\u0013\r\tiJ\u0018\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAAS!\u0019\t9+!,\u000226\u0011\u0011\u0011\u0016\u0006\u0004\u0003W[\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003_\u000bIKA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAAZU5\t\u0001AA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0005U\u0005eF\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\u0011\ty,!\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0007\fiL\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001\u0003;ie\u0016\fG-\u00133\u0011\u0007]\u000bI-C\u0002\u0002Lb\u00131!\u00138u)\u0011\t\t,a4\t\u000f\u0005\u0015G\u00061\u0001\u0002H\u0006QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\t\u0005m\u0017qA\u0001\u0005Y\u0006tw-\u0003\u0003\u0002`\u0006e'AB*ue&tw-A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005\u0015\b\u0003BA\u0015\u0003OL1!!;Q\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"!!=\u0011\t\u0005%\u00121_\u0005\u0004\u0003k\u0004&\u0001D\"mK\u0006tWM]*uCR\u001c\u0018!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002v\u0005m\b\"CA?c\u0005\u0005\t\u0019AAy\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0004e\u0005\r\u0015!\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ugV\u0011!Q\u0001\t\u0005\u0003S\u00119!C\u0002\u0003\nA\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0005\u0003k\u0012y\u0001C\u0005\u0002~Q\n\t\u00111\u0001\u0003\u0006\u0005\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\r)\u00141Q\u0001\nG\",7m\u001b#p]\u0016$B!!\u001e\u0003\u001a!9!1\u0004\u001cA\u0002\u0005m\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007I><vN]6\u0015\u0005\u0005U\u0014\u0001\u0006;ss\u000ecW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0003&A\u0019qKa\n\n\u0007\t%\u0002LA\u0004C_>dW-\u00198\u0002#\rdW-\u00198GS2$\b.[3ti2{w\rK\u0003:\u0005_\u0011Y\u0004E\u0003X\u0005c\u0011)$C\u0002\u00034a\u0013a\u0001\u001e5s_^\u001c\b\u0003BA\u0015\u0005oI1A!\u000fQ\u0005QaunZ\"mK\u0006t\u0017N\\4Fq\u000e,\u0007\u000f^5p]\u000e\u0012!QG\u0001\tG2,\u0017M\u001c'pOR!\u0011Q\u000fB!\u0011\u001d\u0011\u0019E\u000fa\u0001\u0005\u000b\n\u0011b\u00197fC:\f'\r\\3\u0011\t\u0005%\"qI\u0005\u0004\u0005\u0013\u0002&A\u0003'pOR{7\t\\3b]\u0006Y!/Z2pe\u0012\u001cF/\u0019;t)1\t)Ha\u0014\u0003T\t-$Q\u000fB=\u0011\u001d\u0011\tf\u000fa\u0001\u0003\u000f\f!!\u001b3\t\u000f\tU3\b1\u0001\u0003X\u0005!a.Y7f!\u0011\u0011IFa\u001a\u000f\t\tm#1\r\t\u0004\u0005;BVB\u0001B0\u0015\r\u0011\t\u0007V\u0001\u0007yI|w\u000e\u001e \n\u0007\t\u0015\u0004,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\u0014IGC\u0002\u0003faCqA!\u001c<\u0001\u0004\u0011y'\u0001\u0003ge>l\u0007cA,\u0003r%\u0019!1\u000f-\u0003\t1{gn\u001a\u0005\b\u0005oZ\u0004\u0019\u0001B8\u0003\t!x\u000eC\u0004\u0003|m\u0002\r!!=\u0002\u000bM$\u0018\r^:\u0002\u0013\rdW-\u00198feN\u0004\u0013!F7bq>3XM]\"mK\u0006tWM\u001d+ie\u0016\fGm\u001d\u000b\u0005\u0003\u000f\u0014\u0019\tC\u0004\u0003\u0006V\u0001\rAa\"\u0002\u0003\u0019\u0004ra\u0016BE\u0003c\u0013i)C\u0002\u0003\fb\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007]\u0013y)C\u0002\u0003\u0012b\u0013a\u0001R8vE2,\u0017a\u00043fC\u0012$\u0006N]3bI\u000e{WO\u001c;\u0016\u0005\u0005\u001d\u0017aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006i!/Z7pm\u0016lU\r\u001e:jGN\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003\"B)!Pa)\u0003X%\u0019!QU>\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011Q\u000fBV\u0011\u001d\u0011ik\u0007a\u0001\u0005_\u000b\u0011B\\3x\u0007>tg-[4\u0011\u0007\r\u0014\t,C\u0002\u00034\u0012\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t)H!/\u0003>\"9!1\u0018\u000fA\u0002\t=\u0016!C8mI\u000e{gNZ5h\u0011\u001d\u0011i\u000b\ba\u0001\u0005_\u000bQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA;\u0005\u0007DqAa\u0007\u001e\u0001\u0004\tY\"A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!!\u001e\u0003J\n5\u0007B\u0002Bf=\u0001\u0007q0A\u0004eCR\fG)\u001b:\t\u0013\t=g\u0004%AA\u0002\tE\u0017!\u00059beRLG/[8o)>\u0014V-\\8wKB)qKa5\u0002\u001c%\u0019!Q\u001b-\u0003\r=\u0003H/[8o\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001c\u0016\u0005\u0005#\u0014in\u000b\u0002\u0003`B!!\u0011\u001dBv\u001b\t\u0011\u0019O\u0003\u0003\u0003f\n\u001d\u0018!C;oG\",7m[3e\u0015\r\u0011I\u000fW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bw\u0005G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\tG\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:\u0015\u0011\u0005U$1\u001fB{\u0005sDqAa\u0007!\u0001\u0004\tY\u0002\u0003\u0004\u0003x\u0002\u0002\ra`\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005w\u0004\u0003\u0019A@\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002v\r\u0005\u0001bBB\u0002C\u0001\u0007!qK\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t)h!\u0003\u0004\f\r5\u0001B\u0002BfE\u0001\u0007q\u0010C\u0004\u0003\u001c\t\u0002\r!a\u0007\t\u000f\r=!\u00051\u0001\u0003p\u00051qN\u001a4tKR\fQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\r\u0006\u0003\u0002v\rU\u0001b\u0002B\u000eG\u0001\u0007\u00111D\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\t)ha\u0007\t\u000f\ruA\u00051\u0001\u0004 \u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003{\u0007C\tY\"C\u0002\u0004$m\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\rC^\f\u0017\u000e^\"mK\u0006tW\r\u001a\u000b\t\u0005K\u0019Ica\u000b\u0004.!9!1D\u0013A\u0002\u0005m\u0001bBB\bK\u0001\u0007!q\u000e\u0005\n\u0007_)\u0003\u0013!a\u0001\u0005_\n\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"a!\u000e+\t\t=$Q\\\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHCAB\u001e!\u0015Q8\u0011EB\u001f!\u001d96qHA\u000e\u0003OI1a!\u0011Y\u0005\u0019!V\u000f\u001d7fe\u0005i1-\u001e:sK:$8i\u001c8gS\u001e\fAb\u00197fC:,'oQ8v]R\f!\u0002T8h\u00072,\u0017M\\3s!\r\tI#P\n\u0003{Y#\"a!\u0013\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u001111\u000b\t\u0006u\n\r\u0016Q[\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2![B.\u0011\u001d\ti'\u0011a\u0001\u0005_\u000bQ%T1y\u0005V4g-\u001a:Vi&d\u0017N_1uS>t\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0002M5\u000b\u0007PQ;gM\u0016\u0014X\u000b^5mSj\fG/[8o!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%\u0001\u0010DY\u0016\fg.\u001a:SK\u000e|\u0007/\u001f)fe\u000e,g\u000e^'fiJL7MT1nK\u0006y2\t\\3b]\u0016\u0014(+Z2paf\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002-5\u000b\u0007p\u00117fC:$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\fq#T1y\u00072,\u0017M\u001c+j[\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002;5\u000b\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-_'fiJL7m\u001d(b[\u0016\fa$T1y\u0007>l\u0007/Y2uS>tG)\u001a7bs6+GO]5dg:\u000bW.\u001a\u0011\u00023\u0011+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG:\u000bW.Z\u0001\u001b\t\u0016\fG\r\u00165sK\u0006$7i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\f\u001b\u0016$(/[2OC6,7/\u0001\u0007NKR\u0014\u0018n\u0019(b[\u0016\u001c\b%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007sRC!a\u0010\u0003^\u0002")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        try {
            this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
            this.cleaners().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

