/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc;

import com.martinkl.warc.WARCRecord;
import com.martinkl.warc.WARCWritable;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WARCFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(WARCFileWriter.class);
    public static final long DEFAULT_MAX_SEGMENT_SIZE = 1000000000L;
    private final Configuration conf;
    private final CompressionCodec codec;
    private final Path workOutputPath;
    private final Progressable progress;
    private final String extensionFormat;
    private final long maxSegmentSize;
    private long segmentsCreated = 0L;
    private long segmentsAttempted = 0L;
    private long bytesWritten = 0L;
    private CountingOutputStream byteStream;
    private DataOutputStream dataStream;

    public WARCFileWriter(Configuration conf, CompressionCodec codec, Path workOutputPath) throws IOException {
        this(conf, codec, workOutputPath, null);
    }

    public WARCFileWriter(Configuration conf, CompressionCodec codec, Path workOutputPath, Progressable progress) throws IOException {
        this.conf = conf;
        this.codec = codec;
        this.workOutputPath = workOutputPath;
        this.progress = progress;
        this.extensionFormat = ".seg-%05d.attempt-%05d.warc" + (codec == null ? "" : codec.getDefaultExtension());
        this.maxSegmentSize = conf.getLong("warc.output.segment.size", 1000000000L);
        this.createSegment();
    }

    public static CompressionCodec getGzipCodec(Configuration conf) {
        try {
            return (CompressionCodec)ReflectionUtils.newInstance(conf.getClassByName("org.apache.hadoop.io.compress.GzipCodec").asSubclass(CompressionCodec.class), (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            logger.warn("GzipCodec could not be instantiated", (Throwable)e);
            return null;
        }
    }

    private void createSegment() throws IOException {
        this.segmentsAttempted = 0L;
        this.bytesWritten = 0L;
        boolean success = false;
        while (!success) {
            Path path = this.workOutputPath.suffix(String.format(this.extensionFormat, this.segmentsCreated, this.segmentsAttempted));
            FileSystem fs = path.getFileSystem(this.conf);
            try {
                FSDataOutputStream fsStream = this.progress == null ? fs.create(path, false) : fs.create(path, this.progress);
                this.byteStream = new CountingOutputStream(new BufferedOutputStream((OutputStream)fsStream));
                this.dataStream = new DataOutputStream(this.codec == null ? this.byteStream : this.codec.createOutputStream((OutputStream)this.byteStream));
                ++this.segmentsCreated;
                logger.info("Writing to output file: {}", (Object)path);
                success = true;
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("File already exists")) {
                    logger.warn("Tried to create file {} but it already exists; retrying.", (Object)path);
                    ++this.segmentsAttempted;
                    continue;
                }
                throw e;
            }
        }
    }

    public void write(WARCRecord record) throws IOException {
        if (this.bytesWritten > this.maxSegmentSize) {
            this.dataStream.close();
            this.createSegment();
        }
        record.write(this.dataStream);
    }

    public void write(WARCWritable record) throws IOException {
        if (record.getRecord() != null) {
            this.write(record.getRecord());
        }
    }

    public void close() throws IOException {
        this.dataStream.close();
    }

    private class CountingOutputStream
    extends FilterOutputStream {
        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            WARCFileWriter.this.bytesWritten += len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            WARCFileWriter.this.bytesWritten++;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

