/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.xml.utils;

public class ObjectVector
implements Cloneable {
    protected final int m_blocksize;
    protected Object[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public ObjectVector(int blocksize, int increaseSize) {
        this.m_blocksize = increaseSize;
        this.m_mapSize = blocksize;
        this.m_map = new Object[blocksize];
    }

    public ObjectVector(ObjectVector v) {
        this.m_map = new Object[v.m_mapSize];
        this.m_mapSize = v.m_mapSize;
        this.m_firstFree = v.m_firstFree;
        this.m_blocksize = v.m_blocksize;
        System.arraycopy(v.m_map, 0, this.m_map, 0, this.m_firstFree);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(Object value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] newMap = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final void setElementAt(Object value, int index) {
        this.m_map[index] = value;
    }

    public final Object elementAt(int i) {
        return this.m_map[i];
    }

    public final void setToSize(int size) {
        Object[] newMap = new Object[size];
        System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
        this.m_mapSize = size;
        this.m_map = newMap;
    }

    public Object clone() throws CloneNotSupportedException {
        return new ObjectVector(this);
    }
}

