/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.MD5Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DIR_PATTERN = "%s/%s/%s";
    private static final String FILENAME_PATTERN = "%s_%s.%s";
    private static final Integer MAX_LENGTH_OF_FILENAME = 32;
    private static final Integer MAX_LENGTH_OF_EXTENSION = 5;

    public static String getUrlMD5(String url) {
        byte[] digest = MD5Hash.digest((String)url).getDigest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String createTwoLevelsDirectory(String basePath, String md5, boolean makeDir) {
        String firstLevelDirName = "" + md5.charAt(0) + md5.charAt(8);
        String secondLevelDirName = "" + md5.charAt(16) + md5.charAt(24);
        String fullDirPath = String.format(DIR_PATTERN, basePath, firstLevelDirName, secondLevelDirName);
        if (makeDir) {
            try {
                FileUtils.forceMkdir((File)new File(fullDirPath));
            }
            catch (IOException e) {
                LOG.error("Failed to create dir: {}", (Object)fullDirPath);
                fullDirPath = null;
            }
        }
        return fullDirPath;
    }

    public static String createTwoLevelsDirectory(String basePath, String md5) {
        return DumpFileUtil.createTwoLevelsDirectory(basePath, md5, true);
    }

    public static String createFileName(String md5, String fileBaseName, String fileExtension) {
        if (fileBaseName.length() > MAX_LENGTH_OF_FILENAME) {
            LOG.info("File name is too long. Truncated to {} characters.", (Object)MAX_LENGTH_OF_FILENAME);
            fileBaseName = StringUtils.substring((String)fileBaseName, (int)0, (int)MAX_LENGTH_OF_FILENAME);
        }
        if (fileExtension.length() > MAX_LENGTH_OF_EXTENSION) {
            LOG.info("File extension is too long. Truncated to {} characters.", (Object)MAX_LENGTH_OF_EXTENSION);
            fileExtension = StringUtils.substring((String)fileExtension, (int)0, (int)MAX_LENGTH_OF_EXTENSION);
        }
        fileBaseName = fileBaseName.replaceAll("\\?", "");
        fileExtension = fileExtension.replaceAll("\\?", "");
        return String.format(FILENAME_PATTERN, md5, fileBaseName, fileExtension);
    }

    public static String createFileNameFromUrl(String basePath, String reverseKey, String urlString, String epochScrapeTime, String fileExtension, boolean makeDir) {
        String fullDirPath = basePath + File.separator + reverseKey + File.separator + DigestUtils.sha1Hex((String)urlString);
        if (makeDir) {
            try {
                FileUtils.forceMkdir((File)new File(fullDirPath));
            }
            catch (IOException e) {
                LOG.error("Failed to create dir: {}", (Object)fullDirPath);
                fullDirPath = null;
            }
        }
        if (fileExtension.length() > MAX_LENGTH_OF_EXTENSION) {
            LOG.info("File extension is too long. Truncated to {} characters.", (Object)MAX_LENGTH_OF_EXTENSION);
            fileExtension = StringUtils.substring((String)fileExtension, (int)0, (int)MAX_LENGTH_OF_EXTENSION);
        }
        String outputFullPath = fullDirPath + File.separator + epochScrapeTime + "." + fileExtension;
        return outputFullPath;
    }

    public static String displayFileTypes(Map<String, Integer> typeCounts, Map<String, Integer> filteredCounts) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nTOTAL Stats:\n");
        builder.append("[\n");
        int mimetypeCount = 0;
        for (String mimeType : typeCounts.keySet()) {
            builder.append("    {\"mimeType\":\"");
            builder.append(mimeType);
            builder.append("\",\"count\":\"");
            builder.append(typeCounts.get(mimeType));
            builder.append("\"}\n");
            mimetypeCount += typeCounts.get(mimeType).intValue();
        }
        builder.append("]\n");
        builder.append("Total count: " + mimetypeCount + "\n");
        mimetypeCount = 0;
        if (!filteredCounts.isEmpty()) {
            builder.append("\nFILTERED Stats:\n");
            builder.append("[\n");
            for (String mimeType : filteredCounts.keySet()) {
                builder.append("    {\"mimeType\":\"");
                builder.append(mimeType);
                builder.append("\",\"count\":\"");
                builder.append(filteredCounts.get(mimeType));
                builder.append("\"}\n");
                mimetypeCount += filteredCounts.get(mimeType).intValue();
            }
            builder.append("]\n");
            builder.append("Total filtered count: " + mimetypeCount + "\n");
        }
        return builder.toString();
    }
}

