/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.strategies.collections.queue;

import de.vandermeer.skb.interfaces.strategies.collections.IsQueueStrategy;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.NotImplementedException;

public interface ArrayBlockingQueueStrategy<T>
extends IsQueueStrategy<ArrayBlockingQueue<T>, T> {
    @Override
    default public ArrayBlockingQueue<T> get(Collection<T> collection) {
        throw new NotImplementedException("cannot implement get(collection) on array blocking queue w/o capacity, see interface for alternative");
    }

    @Override
    default public ArrayBlockingQueue<T> get() {
        throw new NotImplementedException("cannot implement get() on array blocking queue w/o capacity, see interface for alternative");
    }

    public int getCapacity();

    default public ArrayBlockingQueue<T> get(int capacity, Collection<T> collection) {
        ArrayBlockingQueue<T> ret = new ArrayBlockingQueue<T>(capacity);
        if (collection != null) {
            ret.addAll(collection);
        }
        return ret;
    }

    default public ArrayBlockingQueue<T> get(int capacity) {
        return new ArrayBlockingQueue(capacity);
    }

    public static <T> ArrayBlockingQueueStrategy<T> create(final int capacity) {
        return new ArrayBlockingQueueStrategy<T>(){

            @Override
            public int getCapacity() {
                return capacity;
            }
        };
    }
}

